(*Made for Stephane Jantzens Super Breakout on the Ti-85. Will be distributed
with his next version as a complimentary DOS editor*)

(*Note! All routines,procedures,functions,etc... are all of my own creation
unless otherwise noted... sorry if I re-invented the wheel, I don't have
many examples to look at.*)

Program Editor;
Uses Crt,Dos;
Type Field=array[1..6,1..24] of Boolean;
     All=array[0..24,1..6,1..3] of Char;
     Default=array[0..24,1..18] of Char;
Const PX=2; {Co-ordinates for the edit window}
      PY=8;
      (*These values are the origional levels right side up!*)
      Origional:Default = (                                                            {Stephanes description of them}
      {0} (#$54,#$41,#$15,#$44,#$51,#$10,#$44,#$45,#$14,#$44,#$41,#$10,#$54,#$41,#$15,#$0,#$0,#$0), {"ONE"}
      {1} (#$0,#$11,#$0,#$0,#$55,#$40,#$0,#$55,#$40,#$0,#$55,#$40,#$0,#$15,#$0,#$0,#$4,#$0), {heart}
      {2} (#$14,#0,#$54,#$55,#1,#$11,#$50,#$1,#$55,#$50,#$21,#$55,#$55,#1,#$55,#$14,#$1,#$11), {pacman}
      {3} (#$55,#$55,#$55,#$55,#$55,#$55,#$0,#$0,#$0,#$0,#$0,#$0,#$55,#$55,#$55,#$55,#$55,#$55), {1-0-1}
      {4} (#$54,#$85,#$4A,#$10,#$84,#$48,#$10,#$85,#$4A,#$10,#$84,#$42,#$10,#$85,#$4A,#$0,#$0,#$0), {"TI-85"}
      {5} (#$0,#$55,#$0,#$5,#$55,#$50,#$55,#$55,#$55,#$55,#$55,#$55,#$5,#$55,#$50,#$0,#$55,#$0), {diamond}
      {6} (#$50,#$55,#$5,#$41,#$96,#$41,#$41,#$55,#$41,#$41,#$96,#$41,#$41,#$69,#$41,#$50,#$55,#$5), {smile}
      {7} (#$AA,#$AA,#$AA,#$95,#$82,#$56,#$94,#$0,#$16,#$94,#$0,#$16,#$95,#$82,#$56,#$AA,#$82,#$AA), {two rooms}
      {8} (#$55,#$55,#$55,#$20,#$82,#$8,#$20,#$82,#$8,#$20,#$82,#$8,#$20,#$82,#$8,#$55,#$55,#$55), {ladder}
      {9} (#$A,#$AA,#$20,#$9,#$56,#$20,#$9,#$56,#$20,#$9,#$40,#$20,#$9,#$40,#$20,#$A,#$AA,#$A0), {snail}
      {10} (#$AA,#$AA,#$AA,#$95,#$55,#$56,#$96,#$55,#$96,#$96,#$55,#$96,#$96,#$55,#$96,#$8A,#$82,#$A2), {compartment}
      {11} (#$40,#$0,#$1,#$50,#$0,#$5,#$54,#$0,#$15,#$55,#$0,#$55,#$55,#$41,#$55,#$AA,#$82,#$AA), {twin stairs}
      {12} (#$2A,#$0,#$54,#$AA,#$81,#$55,#$A9,#$42,#$95,#$A5,#$42,#$A5,#$55,#$42,#$AA,#$15,#$0,#$A8), {yin-yang}
      {13} (#$A,#$AA,#$A0,#$9,#$55,#$60,#$9,#$55,#$60,#$9,#$55,#$60,#$9,#$55,#$60,#$A,#$82,#$A0), {the trap}
      {14} (#$AA,#$AA,#$AA,#$80,#$0,#$2,#$0,#$14,#$0,#$5A,#$55,#$A5,#$59,#$55,#$65,#$A9,#$55,#$6A), {temple}
      {15} (#$A,#$AA,#$A0,#$55,#$55,#$55,#$55,#$55,#$55,#$5A,#$AA,#$A5,#$55,#$55,#$55,#$55,#$55,#$55), {twin bars}
      {16} (#$AA,#$AA,#$AA,#$55,#$55,#$55,#$55,#$55,#$55,#$44,#$44,#$44,#$44,#$44,#$44,#$88,#$88,#$88), {castel}
      {17} (#$11,#$11,#$11,#$44,#$44,#$44,#$11,#$11,#$11,#$44,#$44,#$44,#$11,#$11,#$11,#$44,#$44,#$44), {diagonals}
      {18} (#$55,#$55,#$55,#$55,#$55,#$55,#$55,#$55,#$55,#$55,#$82,#$55,#$56,#$0,#$95,#$A8,#$0,#$2A), {entrance}
      {19} (#$55,#$55,#$55,#$55,#$55,#$55,#$55,#$96,#$55,#$55,#$96,#$55,#$0,#$96,#$0,#$0,#$AA,#$0), {small bowl}
      {20} (#$0,#$0,#$0,#$52,#$A1,#$62,#$42,#$21,#$22,#$52,#$A1,#$48,#$42,#$20,#$48,#$52,#$21,#$48), {"EASY"}
      {21} (#$0,#$0,#$0,#$2,#$55,#$80,#$2,#$55,#$80,#$2,#$55,#$80,#$2,#$55,#$80,#$2,#$AA,#$80), {big bowl}
      {22} (#$54,#$28,#$15,#$50,#$96,#$5,#$42,#$55,#$81,#$4A,#$55,#$A1,#$42,#$69,#$81,#$42,#$69,#$81), {pagoda}
      {23} (#$11,#$11,#$8,#$88,#$88,#$88,#$11,#$11,#$8,#$88,#$88,#$88,#$11,#$11,#$8,#$AA,#$AA,#$A8), {8-ball}
      {24} (#$55,#$55,#$55,#$6A,#$AA,#$A9,#$55,#$55,#$55,#$6A,#$AA,#$A9,#$55,#$55,#$55,#$6A,#$AA,#$A9)); {inferno}

Var Level:Field; {The "working" array for the current level}
    AllLevels:All; {Storage space for the 25 loaded levels}
    Current,X,Y,Test,C,A,B:Integer;
    Ch:Char;
    One,Two,Three:String[8];
    OneA,TwoA,ThreeA,OneB,TwoB,ThreeB:String;
    Strin:String;
    Done,SaveLevel,None:Boolean;
    File1,File2:Text;
    Temp:String[8];

(*I think I've seen something like this in the SWAG before so maybe it's not
totally origional.*)

Function SupCase(S:String):String;
Var Temp:String;
    A:Integer;
Begin
Temp:='';
For A:=1 to Length(S) do Temp:=Temp+UpCase(S[A]);
SupCase:=Temp
End;

(*My little four bit to hex thingie*)

Function Bin2Hex(Bits:String):Char;
Begin
If Bits='0000' then Bin2Hex:='0'
Else if Bits='0001' then Bin2Hex:='1'
Else if Bits='0010' then Bin2hex:='2'
Else if Bits='0011' then Bin2hex:='3'
Else if Bits='0100' then Bin2hex:='4'
Else if Bits='0101' then Bin2hex:='5'
Else if Bits='0110' then Bin2hex:='6'
Else if Bits='0111' then Bin2hex:='7'
Else if Bits='1000' then Bin2hex:='8'
Else if Bits='1001' then Bin2hex:='9'
Else if Bits='1010' then Bin2hex:='A'
Else if Bits='1011' then Bin2hex:='B'
Else if Bits='1100' then Bin2hex:='C'
Else if Bits='1101' then Bin2hex:='D'
Else if Bits='1110' then Bin2hex:='E'
Else if Bits='1111' then Bin2hex:='F'
End;

(*My little Hex to four bit thingie*)

Function Hex2Bin(Hexbyte:Char):String;
Begin
Case Hexbyte of
'0':Hex2Bin:='0000';
'1':Hex2Bin:='0001';
'2':Hex2Bin:='0010';
'3':Hex2Bin:='0011';
'4':Hex2Bin:='0100';
'5':Hex2Bin:='0101';
'6':Hex2Bin:='0110';
'7':Hex2Bin:='0111';
'8':Hex2Bin:='1000';
'9':Hex2Bin:='1001';
'A':Hex2Bin:='1010';
'B':Hex2Bin:='1011';
'C':Hex2Bin:='1100';
'D':Hex2Bin:='1101';
'E':Hex2Bin:='1110';
'F':Hex2Bin:='1111'
End
End;

(*My coolimo Hex function, a little modified for this program... might not
be 100% modular anymore, check the SWAG for some of my units.*)

Function TenTo16(Num1:Integer):String;

Var Res:Longint;
    Num2,C,HiC,B, a:Integer;
    Tempstrin:String;
    First:Boolean;

{One digit Hex conversion... needed for TenTo16}
     Function OneDig(One:Integer):Char;
     Const Hex:Array[0..15] of Char='0123456789ABCDEF';
     Begin
     OneDig:=Hex[One]
     End;

Begin
Num2:=Num1;
TenTo16:='';
Tempstrin:='';
First:=True;                    {This is the first time through the loop.}
A:=0;
repeat                          {This whole proccess!}
C:=0;                           {This keeps track of the positional value.}
repeat                          {Divides One by 16^c until the result is<1}
Inc(c);
Res:=Num1 Div Trunc(exp(c*ln(16))); {Result of Num Div by 16^c}
Until Res<1;                    {Until 16^c > Num}
Dec(c);                         {Bring C back to last Res>=1 value.}
Res:=Num1 Div Trunc(exp(c*ln(16))); {Stores value of that.}
Num1:=Num1 Mod Trunc(exp(c*ln(16))); {And the remainder as the new Num.}
If First Then Begin               {First time? Save C's value.}
   First:=False;
   HiC:=C
   End
Else                            {Otherwise...}
    Begin                        {If any of the digits were 0, add them.}
    A:=HiC-C; (*This is incase you have a number like 4096 where it is*)
    HiC:=C;   (*finished quickly, makes sure no 0's are left out.*)
    If (A>1) then For B:=2 to (A) do TempStrin:=TempStrin+'0' {Add 0's}
    End;
Tempstrin:=Tempstrin+OneDig(Res);{Add the next hex digit to string.}
until C=0;                      {Whole thing until last position is done.}
If Num2<16 then Tempstrin:='0'+Tempstrin;
TenTo16:=Tempstrin
End;

(*Duh... I'm sure there's a better way of doing this, but it's the best I
could think of.*)

Function Reverse(S:String):String;
Var Temp:String;
    C:Integer;
Begin
Temp:=S;
If S='' then Reverse:='';
For C:=1 to Length(S) do Temp[C]:=S[Length(S)-C+1];
Reverse:=Temp
End;

(*Does just about any base to 10. Capitols only for letters.*)

Function ConvTo10(Numb:String;Base:Integer):Integer;
Var C, Value:Integer;
    Total:Integer;
Begin
Value:=0;
Total:=0;
Numb:=Reverse(Numb);            {Makes it easier to work with.}
For C:=1 to Length(Numb) do
Begin
If Numb[C] in ['0'..'9'] then Value:=ord(Numb[C])-ord('0') {0-9}
Else Value:=(ord(Numb[C])-ord('A'))+10;                    {A-Z}
If C>1 then Total:=Total+Trunc(Value*(Base*exp((C-2)*ln(Base)))) {Positional value}
Else Total:=Total+Value; {Only for the first position.}
End;
ConvTo10:=Total
End;

(*Gives TempB a 1 or 0 for the boolean in Levels[A,G..H] for drawing the
binary values on the screen, etc...*)

Procedure Process(Var TempB:String;G,H:Integer);
Var Count:Integer;
Begin
For Count:=G to H do If Level[A,Count]=True then TempB:=TempB+'1'
    Else TempB:=TempB+'0'
End;

(*Used to get the most recent binary values into OneA,OneB,etc... then puts
the hex equivlent of those into One,Two,Three.*)

Procedure MakeABHex;
Begin
OneA:='';
OneB:='';
TwoA:='';
TwoB:='';
ThreeA:='';
ThreeB:='';
Process(OneA,1,4);
Process(OneB,5,8);
Process(TwoA,9,12);
Process(TwoB,13,16);
Process(ThreeA,17,20);
Process(ThreeB,21,24);
One:=Bin2Hex(OneA)+Bin2Hex(OneB);
Two:=Bin2Hex(TwoA)+Bin2Hex(TwoB);
Three:=Bin2Hex(ThreeA)+Bin2Hex(ThreeB)
End;

(*This is why we did all that OneA,OneB,etc.. stuff up there*)

Procedure DrawHex;
Begin
MakeABHex;
TextBackGround(LightGray);
TextColor(White);
Write(' ');
TextBackGround(Black);
Write('.db $',One,' $',Two,' $',Three);
TextBackGround(LightGray);
Write(' ');
TextBackGround(Black);
Write(OneA,OneB,' ',TwoA,TwoB,' ',ThreeA,ThreeB)
End;

(*Draws the extended ascii blocks, and the .db's along with the binary
equivlents.*)

Procedure DrawLevel;
Begin
TextColor(White);
GotoXy(1,PY);
For A:=1 to 6 do
Begin
TextBackGround(LightGray);
Write(' ');
TextBackGround(Black);
For B:=1 to 24 do
Begin
C:=B;
If (Odd(C)) then
Begin
If Level[A,C]=False then
Begin
If Level[A,C+1]=False then Write(#255,#255,#255) {Empty}
Else Write(#176,#176,#176)                      {Breakable}
End
Else If Level[A,C+1]=True then Write(#178,#178,#178) {Bonus}
Else Write(#177,#177,#177)                           {Unbreakable}
End
End;
DrawHex
End;
B:=(X+1) div 3; {Just converts the screen positions into 1-23 and 1-6}
B:=(B*2)-1;
A:=Y-PY+1;
GotoXY(PX,PY-2);
Writeln('X=',B:1,' ','Y=',A:1,' ')
End;

(*For keys A,S,D,F; so you don't have to hit a bunch of spaces*)

Procedure SetBlock(I:Byte);
Begin
Case I of
0:Begin
       Level[A,B]:=False;
       Level[A,B+1]:=False
       End;
1:Begin
       Level[A,B]:=False;
       Level[A,B+1]:=True
       End;
2:Begin
       Level[A,B]:=True;
       Level[A,B+1]:=False
       End;
3:Begin
       Level[A,B]:=True;
       Level[A,B+1]:=True
       End
End
End;

(*For quicker editing, makes one row change.*)

Procedure SetRow(Huh,What:Integer);
Var G:Integer;
Begin
For G:=1 to 24 do
Case What of
0:Level[Huh,G]:=False;
1:Begin
  If Odd(G) then Level[Huh,G]:=False
  Else Level[Huh,G]:=True
  End;
2:Begin
  If Odd(G) then Level[Huh,G]:=True
  Else Level[Huh,G]:=False
  End;
3:Level[Huh,G]:=True
End
End;

(*Same, but one column*)

Procedure SetCol(Huh,What:Integer);
Var G:Integer;
Begin
For G:=1 to 6 do
Begin
Case What of
0,1:Level[G,Huh]:=False;
2,3:Level[G,Huh]:=True;
End;
Case What of
0,2:Level[G,Huh+1]:=False;
1,3:Level[G,Huh+1]:=True
End
End
End;

(*Incrents one block from 00 to 11 then back to 00*)

Procedure ChangeBlock;
Begin
If Level[A,B]=False then
Begin
If Level[A,B+1]=False then Level[A,B+1]:=True
Else
    Begin
    Level[A,B]:=True;
    Level[A,B+1]:=False
    End
End
Else If Level[A,B]=True then
Begin
If Level[A,B+1]=False then Level[A,B+1]:=True
Else
    Begin
    Level[A,B]:=False;
    Level[A,B+1]:=False
    End
End
End;

(*Doh! I forgot what this one does!*)

Procedure Pause;
Var Ch:Char;
Begin
Repeat
Ch:=ReadKey
Until Ch=#13
End;

(*Makes that neat little help thingie that tells what each block is.
and draws the header...*)

Procedure DrawTitle;
Begin
TextColor(Black);
GotoXY(1,1);
Writeln('                          ----------------------------');
GotoXY(1,2);
Writeln('                        Super Breakout level maker!v1.0');
GotoXY(1,3);
Writeln('                         (c) Donald Campbell - 1/31/96');
GotoXY(1,4);
Writeln('                   Space to toggle block. A-F to set a block.');
GotoXY(1,5);
Writeln('                       -/+ to cycle levels.  Esc to quit.');
GotoXY(1,6);
Writeln('                   1-8 odds to set rows and evens for columns.');
GotoXY(PX+25,PY+7);
Writeln('Current level=',Current+1,' ');
GotoXY(PX+25,PY+9);
Writeln('Alt+[Level number] to go straight to level.');
GotoXY(PX+30,PY+11);
Writeln('Press "Q" to exit and save levels.');
GotoXY(PX+30,PY+13);
Writeln('Press "h" for quick help.');
TextColor(White);
TextBackGround(Black);
GotoXY(PX,PY+7);
Write(#255,#255,#255);
GotoXY(PX+4,PY+7);
Writeln('Is an empty space.');
GotoXY(PX,PY+9);
Write(#176,#176,#176);
GotoXY(PX+4,PY+9);
Writeln('Is a normal brick.');
GotoXY(PX,PY+11);
Write(#177,#177,#177);
GotoXY(PX+4,PY+11);
Writeln('Is an unbreakable brick.');
GotoXY(PX,PY+13);
Write(#178,#178,#178);
GotoXY(PX+4,PY+13);
Writeln('Is a bonus brick.');
GotoXY(PX,PY+15);
Write(#219,#219,#219);
GotoXY(PX+4,PY+15);
Writeln('Is where you currently are in the map.')
End;

(*Brings up help, then redraws everything.*)

Procedure Help;
Var Z:Integer;
Begin
TextBackGround(LightGray);
TextColor(Black);
ClrScr;
Writeln('                          ----------------------------');
Writeln('                        Super Breakout level maker!v1.0');
Writeln('                         (c) Donald Campbell - 1/31/96');
Writeln;
Writeln('  Note: If there is not a       BRICKS ARE:         Note: Level numbers');
Writeln('  valid SBLEVELS.85S file      A,00: Blank          are one higher than');
Writeln('  in the current directory     S,01: Breakable      what it will appear as');
Writeln('  the default 25 levels are    D,10: UnBreakable    in Super Breakout.');
Writeln('  loaded.                      F,11: Bonus          Ex. Level1(Here)=Level0(SB)');
Writeln;
Writeln('  Space "toggles" the current block. In other words, if it was 00 before,');
Writeln(' now it''s 01, if a 01 before, now it''s a 10, etc..');
Writeln;
Writeln(' A,S,D,F simply set the current brick to the approprate value.');
Writeln;
Writeln(' Number: Sets the current: To:       Note: Empty levels are not permitted.');
Writeln(' 1       Row                  A      If you attempt to change levels or');
Writeln(' 2       Column               A      save changes with an empty level on');
Writeln(' 3       Row                  S      the screen, it will be replaced with');
Writeln(' 4       Column               S      the appropriate level from the origional');
Writeln(' 5       Row                  D      25 that came with Super Breakout.');
Writeln(' 6       Column               D      (A level must contain at least');
Writeln(' 7       Row                  F      ONE breakable brick to not be empty.)');
Writeln(' 8       Column               F');
Write('                               <Press Enter>');
Pause; {Can you tell I program the TI-85? :}
ClrScr;
DrawTitle;
DrawLevel
End;

(*Makes the level array.*)

Procedure MakeLevel(Hex:String;Where:Integer); (*Where = 1..18*)
Var E,Row,Col,ArrayPos:Integer;
    Q:Boolean;
Begin
Temp:='';
Temp:=Hex2Bin(Hex[1]);
Temp:=Temp+Hex2Bin(Hex[2]);   {Makes an 8 bit string of boolean from a Char}
{Hows this for math?}
Where:=(0-Where)+19;          {Makes 1-18 into 18-1}
ArrayPos:=144-(Where * 8)+1;  {Figures out where in the array that is}
Row:=(ArrayPos Div 24)+1;     {Figures out what row that would be}
Col:=ArrayPos-((Row-1)*24);   {Figures out what column that is}
For E:=1 to 8 do              {Then puts it into the level array}
Begin
If Temp[E]='1' then Q:=True
   Else Q:=False;
Level[Row,Col+E-1]:=Q
End
End;

(*Checks to make sure some idiot doesn't try so save an empty level... must
have at least one breakable brick. How do I know it's breakable? Simple, since
AllLevels is 1-6, 1-24, I can loop from 1-6 each time checking 1-24; if an
odd position is false, and the following even space is true, then that is a
breakable brick and the level is not empty.*)

Function Empty(Which:Integer):Boolean;
Var A,B:Integer;
Begin
Empty:=True;
For A:=1 to 6 do
For B:=1 to 24 do
If Odd(B) then If (Level[A,B]=False) AND (Level[A,B+1]=True) then Empty:=False
End;

(*Gets values from AllLevels; puts a new level into Level*)

Procedure LoadLevel(Which:Integer);
Var A,B,C:Integer;
    TempHex:String[2];
Begin
Current:=Which;
Strin:='';
For A:=1 to 6 do
For B:=1 to 3 do
Begin
    Ch:=AllLevels[Which,A,B];     {Read one character=4 bricks}
    TempHex:=TenTo16(Ord(Ch)); {Convert that to hex}
    {Yeah... math is my strong suit.}
    MakeLevel(TempHex,((A-1)*3+B)) {Put those bits in the right array positions}
    End;
TextColor(Black);
TextBackGround(White);
GotoXY(PX+25,PY+7);
Writeln('Current level=',Current+1,' ')
End;

(*Loads the specified origional level into AllLevels.*)

Procedure LoadDefault(Which:Integer);
Var A,B:Integer;
Begin
For A:=1 to 6 do
For B:=1 to 3 do
AllLevels[Which,A,B]:=Origional[Which,((A*3)+B-3)] {Look familiar?}
End;

(*Saves a level into the AllLevels array after editing, when you change
the Current level.*)

Procedure Store(Which:Integer);
Var Uno,Dos,Third:Integer;
Begin
If Not(Empty(Which)) then {If the level is not empty, store it}
Begin
For A:=6 downto 1 do
    Begin
    MakeABHex;
One:=Bin2Hex(OneA)+Bin2Hex(OneB); {Converts Level to hex}
Two:=Bin2Hex(TwoA)+Bin2Hex(TwoB);
Three:=Bin2Hex(ThreeA)+Bin2Hex(ThreeB);
Uno:=ConvTo10(One,16);             {Converts Hex to Decimal}
Dos:=ConvTo10(Two,16);
Third:=ConvTo10(Three,16);
AllLevels[Which,A,1]:=Chr(Uno);     {Saves the Chr of those to AllLevels}
AllLevels[Which,A,2]:=Chr(Dos);
AllLevels[Which,A,3]:=Chr(Third)
End
End
Else
LoadDefault(Which)                 {Otherwise load orgional}
End;

(*Handles Keypresses for drawing area*)
(*Mostly one big Case statement*)

Procedure MoveMap;
Begin
Repeat
Ch:=ReadKey;
Case Ord(Ch) of
72:Begin {Down}
        If Y<=PY then Y:=PY+5
        Else Dec(Y)
        End;
80:Begin  {Up}
        If Y>=PY+5 then Y:=PY
        Else Inc(Y)
        End;
75:Begin  {Left}
        If X<=2 then X:=35
        Else For A:=1 to 3 do Dec(X)
        End;
77:Begin  {Right}
        If X>=35 then X:=2
        Else For A:=1 to 3 do Inc(X)
        End;
1..25:Begin{Alt-1..25}
     Store(Current);
     LoadLevel(Ord(Ch)-1)
     End;
61:Case Current of{+/=} {Imbedded Case command, Yippie!}
0..23:Begin
     Store(Current);
     LoadLevel(Current+1)
     End;
24:Begin
     Store(Current);
     LoadLevel(0)
     End
End;
45:Case Current of{-/_} {Another imbedded one!}
1..24:Begin
     Store(Current);
     LoadLevel(Current-1)
     end;
0:Begin
     Store(Current);
     LoadLevel(24)
     End;
End;
32:ChangeBlock;
97,65:SetBlock(0);{A}
115,83:SetBlock(1);{S}
100,68:SetBlock(2);{D}
102,70:SetBlock(3);{F}
104:HELP;{H}
49:SetRow(A,0);{1}
50:SetCol(B,0);{2}
51:SetRow(A,1);{3}
52:SetCol(B,1);{4}
53:SetRow(A,2);{5}
54:SetCol(B,2);{6}
55:SetRow(A,3);{7}
56:SetCol(B,3);{8}
113,81:Begin {Q/q}
     Store(Current);
     SaveLevel:=True;
     Ch:=#27
     End
End;

DrawLevel;
GotoXY(X,Y);
Write(#219,#219,#219) {Current block "cursor" thing}
Until Ord(Ch)=27
End;

(*Function borrowed from Pascal-Robots source code.*)

Function Exists(Var Afile:Text):Boolean;
Begin
Exists:=True;
{$I-}
Reset(Afile);
{$I-}
If IOResult<>0 then Exists:=False
End;

(*Checks to make sure the specified *.85S is in proper SBLEVELS format*)

Function CheckFile(Var AFile:Text):Boolean;
Begin
CheckFIle:=False;
Readln(File1,Temp);
If Pos('**TI85**',Temp)>0 then
Begin
For A:=1 to 42 do Read(File1,Ch);
Read(File1,Temp);
If (Pos('ZS',Temp)>0) then
Begin
For A:=1 to 3 do Read(File1,Ch);
Readln(File1,Temp);
If SupCase(Temp)='SBLEVELS' then {UpperCase of the strings name}
Checkfile:=True {So in actuality any string called sblevels could get}
End {Into my editor... but you'd probably get a bunch of crap on the screen}
End
End;

(*Could stand to be a little more informing.*)

Procedure Error(Where:Char);
Begin
TextBackground(Black);
TextColor(White);
ClrScr;
Case Where of
'N':Writeln('That file doesn''t seem to exist!');
'F':Writeln('That file doesn''t seem to be in the proper format!')
End;
Halt
End;

(*Saves it all to an .ASM file called SBLEVELS*)

Procedure SaveLevels;
Var LevelNum:String[2];

(*Man I'm dumb or something... this is the best way I could figure out how
to make an integer from 0 to 24 a string like "00" or "06" any ideas?*)

Function LNum(A:Integer):String;
Begin
Case A of
0:LNum:='00';1:LNum:='01';2:LNum:='02';3:LNum:='03';4:LNum:='04';5:LNum:='05';
6:LNum:='06';7:LNum:='07';8:LNum:='08';9:LNum:='09';10:LNum:='10';
11:LNum:='11';12:LNum:='12';13:LNum:='13';14:LNum:='14';15:LNum:='15';
16:LNum:='16';17:LNum:='17';18:LNum:='18';19:LNum:='19';20:LNum:='20';
21:LNum:='21';22:LNum:='22';23:LNum:='23';24:LNum:='24'
End
End;

Begin
If SaveLevel then
Begin
Assign(File2,'SBLEVELS.ASM');
ReWrite(File2);
Writeln(File2,';-------------------------------------');
Writeln(File2,';-- Super Breakout Level Editor');
Writeln(File2,';-- (c) 1996 Donald Campbell');
Writeln(File2,';-- Donald.Campbell@manhattan.com');
Writeln(File2,';--');
Writeln(File2,';-- for Super Breakout 5.0 and above');
Writeln(File2,';-- (c) 1996 Stephane Jantzen');
Writeln(File2,';-- Stephane.Jantzen@scinfo.u-nancy.fr');
Writeln(File2,';-------------------------------------');
Writeln(File2);
Writeln(File2,'        .org    $0000');
Writeln(File2,'        .db     "SB Levels",0');
Writeln(File2);
Writeln(File2,';-- beginning of executable code -----');
Writeln(File2);
Writeln(File2,'Start:');
Writeln(File2,'        ret             ;nothing to do');
Writeln(File2);
Writeln(File2,';-- beginning of level definition ----');
Writeln(File2);
Writeln(File2,';-- Bricks convention :');
Writeln(File2,';--  00b : no brick');
Writeln(File2,';--  01b : normal brick');
Writeln(File2,';--  10b : unbreakable brick');
Writeln(File2,';--  11b : bonus brick');
Writeln(File2);
For B:=0 to 24 do
Begin
LoadLevel(B);
Write(File2,'Level');
LevelNum:=LNum(B);
Writeln(File2,LevelNum,':');
For A:=6 downto 1 do
    Begin
    MakeABHex;
    ClrScr;
    One:=Bin2Hex(OneA)+Bin2Hex(OneB);
    Two:=Bin2Hex(TwoA)+Bin2Hex(TwoB);
    Three:=Bin2Hex(ThreeA)+Bin2Hex(ThreeB);
    Writeln(File2,'        .db     $',One,',$',Two,',$',Three)
    End
{Writeln(File2); {To add a line between each level}
End;
Writeln(File2);
Writeln(File2,'        .end');
Close(File2);
TextColor(White);
TextBackGround(Black);
ClrScr
End
End;

(*Gets values from SBLEVELS.85S and puts them into AllLevels*)

Procedure GetLevel(Which:Integer);
Var A,B:Integer;
    TempHex:String[2];
Begin
Reset(File1);
Strin:='';
For A:=1 to 87 do Read(File1,Ch);
{Now at begining of level #00}
If Which > 0 then For A:=1 to Which do {Skip levels if necc.}
For B:=1 to 18 do Read(File1,Ch); {By reading 18 bytes per level}
For A:=6 downto 1 do   {6 DOWNTO 1 because levels are upside down}
For B:=1 to 3 do
    Begin
    Read(File1,Ch);     {Read one character=4 bricks}
    AllLevels[Which,A,B]:=Ch {And put it in the AllLevels array!}
    End
End;

(*MAIN LOOP!!!*)

Begin
SaveLevel:=False;
TextBackGround(LightGray);
ClrScr;
If ParamCount=0 then None:=True;
If ParamCount=1 then
   Begin
   {$I-}
   Assign(File1,ParamStr(1));
   {$I+}
   If IOResult<>0 then Error('N');
   If Exists(File1) then
      Begin
      None:=False;
      Reset(File1);
      If (CheckFile(File1)) then {Make sure it's valid}
         Begin
         For A:=0 to 24 do GetLevel(A);
         Close(File1);
         End
         Else Error('F')
      End
   End;
If None then {If no levels loaded... make a clean slate}
For A:=0 to 24 do LoadDefault(A);
LoadLevel(0);
DrawTitle;
TextColor(15);
X:=PX;
Y:=PY;
DrawLevel;
GotoXY(X,Y);
Write(#219,#219,#219);
MoveMap;
TextColor(White);
TextBackGround(Black);
ClrScr;
SaveLevels;
Writeln('Thanks for using this program. See you on list-zshell!');
Writeln('Thanks to:Stephane Jantzen for making Super Breakout and also putting');
Writeln('up with my annoying questions while I was making this program.');
Writeln('Dan Eble, Magnus Hagander, and Rob Taylor for making ZShell!');
Writeln('Thanks guys! Without your work none of this would be possible!');
Writeln('For comments, suggestions, flames, etc... E-Mail to:');
Writeln('Donald.Campbell@manhattan.com');
NormVideo;
If SaveLevel then Halt(2)
End.
