; translate with (tasm from Borland):
; tasm linktest
; tlink /t linktest

.model tiny
include stdmac.inc
.code
org 100h
main:
	jmp	c1
include stdlib.inc
delay:
	push	ax
	mov	ax, [es:6ch]		; read system timer
delay1:
	cmp	ax, [es:6ch]
	je	delay1			; wait for timer update
	pop	ax
	ret
cableio:
	wstr@	<"send ">
	call	Hexbyte
	out	dx, al			; write al to LPTx data port
	inc	dx
	call	delay			; wait one timer tick
	in	al, dx			; read al from LPTx status port
	dec	dx
	and	al, 30h			; don't mention unimportant data
	wstr@	<" - read ">
	call	Hexbyte
	wstr@	<" - should be ">
	ret
cabletest:
	mov	al, 0			; output data to LPTx
	call	cableio
	wstr@	<"00", 13, 10>		; write the value that should be read
	mov	al, 1			; output data to LPTx
	call	cableio
	wstr@	<"20", 13, 10>		; write the value that should be read
	mov	al, 2			; output data to LPTx
	call	cableio
	wstr@	<"10", 13, 10>		; write the value that should be read
	mov	al, 3			; output data to LPTx
	call	cableio
	wstr@	<"30", 13, 10>		; write the value that should be read
	ret
c1:
	wstr@	<"Test software for the parallel link cable.", 13, 10, "Author: aw4@inf.tu-dresden.de (Andreas Westfeld)", 13, 10, "Version 1.0", 13, 10>
	mov	ax, 40h
	mov	es, ax			; BIOS variable segment
	call	delay			; sync with timer tick
	mov	dx, [es:8]		; read i/o port address for LPT1
	test	dx, dx
	je	no1
	wstr@	<"LPT1 found at ">
	mov	ax, dx
	call	Hexword			; output that address (if not NULL)
	wstr@	<13, 10>
	call	cabletest
	jmp	c2
no1:
	wstr@	<"No LPT1 found.", 13, 10>
c2:
	mov	dx, [es:8+2]		; read i/o port address for LPT2
	test	dx, dx
	je	no2
	wstr@	<"LPT2 found at ">
	mov	ax, dx
	call	Hexword			; output that address (if not NULL)
	wstr@	<13, 10>
	call	cabletest
	jmp	c3
no2:
	wstr@	<"No LPT2 found.", 13, 10>
c3:
	mov	dx, [es:8+4]		; read i/o port address for LPT3
	test	dx, dx
	je	no3
	wstr@	<"LPT3 found at ">
	mov	ax, dx
	call	Hexword			; output that address (if not NULL)
	wstr@	<13, 10>
	call	cabletest
	jmp	c4
no3:
	wstr@	<"No LPT3 found.", 13, 10>
c4:
	ret
end main
