;Plays a 1-Bit, 11kHz, Mono WAV-File over a connected earphone...
; (C) 1996 by Andreas Ess
;If you use the code, please give me an appropriate credit.
;Send a postcard saying thank you to:
; Andreas Ess
; Tufers 156
; A-6811 Goefis
; Austria/Europe
;-----------------------------------------------------------------------------

#INCLUDE "TI-85.H"
#INCLUDE "INTEL.H"

.org 0
.db "PLAYWAVE V0.1 BY AE",0

Start:
 lea(Sound)
 CALL_(PlayWAV)
 ret

PlayWAV:
 cli                    ;greylib by robert taylor can't be used :(
 mov   a, 0C0h
 out   (7), a
 mov   e, (hl)
 inc   hl
 mov   d, (hl)
 inc   hl
 mov   b, 128           ;b is used as a mask
SoundLoop:
 mov   c, 20
DLoop:
 dec   c
 jnz   DLoop
 ror   b
 jnc   Play
 inc   hl               ;next byte
 dec   de
 mov   a, d
 or    e
 jz    DonePlay
 xor   a                ;exit key pressed?
 out   (1), a
 in    a, (1)
 bit   6, a
 jz    DonePlay
Play:
 mov   a, (hl)          ;get bit
 and   b
 jz    Play1
 mov   a, 0FCh
 out   (7), a
 jmp   SoundLoop
Play1:
 mov   a, 0C0h
 out   (7), a
 jmp   SoundLoop
DonePlay:
 mov  a, 0C0h
 out  (7), a
 sti
 ret

;-----------------------------------------------------------------------------
;The WAV-File:
;-----------------------------------------------------------------------------
Sound:
 .dw 10462
 .db $E0,$C3,$FC,$DF,$07,$83,$CF,$F0,$1F,$84,$87,$E7,$80,$00,$00,$0F
 .db $83,$FF,$65,$FC,$1F,$FE,$7F,$7D,$FF,$8F,$80,$81,$F3,$7C,$F8,$18
 .db $01,$34,$00,$30,$1F,$0F,$F3,$C3,$E0,$FD,$F9,$71,$E0,$17,$F0,$04
 .db $0E,$03,$FF,$C3,$80,$18,$59,$F0,$F2,$67,$7F,$F8,$1E,$0E,$07,$97
 .db $E0,$C1,$B1,$04,$7C,$1E,$00,$17,$FF,$F8,$1E,$05,$FE,$61,$F8,$1C
 .db $3E,$7E,$03,$81,$E6,$EE,$07,$00,$18,$0F,$CE,$48,$70,$7F,$FC,$C1
 .db $C0,$74,$7F,$81,$C1,$E3,$7B,$F3,$C0,$10,$03,$C7,$C1,$F0,$93,$F8
 .db $07,$E4,$31,$03,$FC,$7C,$60,$3E,$7F,$0F,$00,$C0,$F3,$3E,$0F,$81
 .db $F8,$3F,$8F,$0C,$01,$F0,$7C,$18,$1E,$1F,$07,$C1,$C2,$06,$7C,$FF
 .db $83,$F9,$FB,$43,$F8,$00,$63,$EB,$D2,$00,$7C,$8F,$C6,$F0,$60,$33
 .db $E7,$C0,$03,$F6,$5F,$8F,$00,$70,$23,$EC,$F8,$41,$F1,$FF,$9F,$00
 .db $00,$1E,$1C,$13,$0F,$8B,$E7,$E5,$03,$E0,$1F,$E6,$C8,$38,$3C,$7C
 .db $3E,$04,$C5,$C3,$C3,$07,$16,$0F,$DF,$98,$18,$3C,$BB,$3C,$07,$C4
 .db $CB,$FB,$04,$1A,$0F,$EC,$38,$3C,$1E,$3F,$3F,$00,$00,$FF,$8B,$C0
 .db $60,$6C,$F8,$3E,$04,$00,$3F,$FB,$80,$3E,$0F,$FE,$0E,$04,$03,$DF
 .db $C6,$01,$03,$9F,$B7,$C0,$18,$1D,$B1,$F0,$04,$FC,$1F,$0F,$07,$07
 .db $C1,$F8,$F0,$40,$0F,$C7,$D0,$10,$03,$70,$78,$60,$78,$3F,$3F,$F8
 .db $81,$F8,$F8,$6F,$00,$38,$F3,$F4,$70,$40,$E0,$7E,$91,$B0,$3E,$3F
 .db $7E,$0E,$0E,$7F,$F6,$7C,$11,$F6,$5F,$83,$81,$82,$07,$E0,$46,$01
 .db $F1,$FF,$38,$06,$0F,$0F,$C3,$00,$0C,$FB,$FE,$00,$0C,$3F,$1F,$80
 .db $43,$0F,$8F,$E7,$0A,$7F,$FE,$3C,$70,$0E,$38,$FF,$84,$00,$F8,$1E
 .db $38,$00,$0F,$00,$FE,$0E,$0C,$FF,$9F,$C0,$E0,$C7,$C3,$F0,$83,$01
 .db $E1,$F3,$30,$70,$CF,$0F,$C1,$C3,$07,$F0,$E7,$83,$C0,$E7,$C3,$E0
 .db $61,$83,$E4,$D0,$80,$78,$3F,$F7,$C0,$B1,$E3,$FC,$03,$03,$C1,$F9
 .db $F8,$E6,$07,$C1,$E3,$E0,$00,$ED,$87,$FC,$60,$04,$FC,$FC,$E0,$40
 .db $27,$E3,$F0,$02,$E0,$C3,$01,$F8,$1E,$0F,$F1,$F7,$C0,$7C,$7F,$C7
 .db $E0,$C0,$E0,$FD,$F0,$78,$3C,$3C,$78,$30,$38,$3E,$3F,$9F,$8C,$F0
 .db $FF,$0F,$81,$D0,$06,$FF,$1F,$03,$C0,$7C,$38,$10,$1C,$19,$F8,$F8
 .db $3B,$73,$FE,$C1,$E3,$E0,$0B,$E1,$F0,$0C,$20,$7E,$0E,$60,$F0,$79
 .db $F8,$F0,$C0,$F1,$F1,$E1,$F0,$E0,$EF,$F0,$43,$E0,$18,$F1,$81,$E0
 .db $E0,$F0,$FC,$1F,$C3,$E7,$F1,$E0,$DE,$07,$C7,$C3,$03,$C3,$87,$C1
 .db $00,$0F,$03,$EF,$87,$83,$C7,$C1,$F1,$F8,$87,$87,$C7,$81,$E0,$CF
 .db $8F,$81,$03,$0F,$1C,$3F,$06,$1C,$FE,$1F,$DC,$1E,$0E,$3C,$1F,$0F
 .db $01,$FE,$1C,$18,$1E,$1C,$3C,$3E,$0F,$1F,$FF,$07,$F0,$6C,$60,$F8
 .db $3E,$07,$83,$FF,$00,$C0,$36,$03,$9C,$FC,$0F,$FD,$FF,$87,$C1,$F1
 .db $05,$E0,$7E,$0F,$0F,$8F,$03,$D0,$30,$0F,$84,$6E,$0F,$FF,$3F,$0F
 .db $81,$EC,$02,$C0,$32,$07,$FB,$38,$0F,$C0,$61,$E1,$E1,$F0,$3F,$CB
 .db $E3,$E7,$C3,$C3,$83,$83,$C0,$1F,$87,$83,$03,$83,$C3,$E7,$07,$E7
 .db $BF,$0F,$C6,$87,$87,$C1,$F0,$78,$38,$3C,$06,$00,$40,$17,$D1,$93
 .db $76,$FC,$FC,$78,$F0,$18,$F1,$E7,$8D,$E1,$F0,$18,$38,$0E,$03,$C3
 .db $C6,$71,$FF,$1F,$07,$C3,$07,$8F,$BE,$1F,$83,$83,$E0,$83,$B8,$01
 .db $C3,$99,$F1,$F7,$D9,$BF,$87,$F0,$33,$E0,$F1,$FC,$C0,$7B,$C1,$C1
 .db $E0,$3C,$F8,$1B,$30,$7C,$FF,$8E,$4F,$80,$F8,$7C,$5F,$1F,$23,$C1
 .db $F0,$7E,$00,$3F,$07,$07,$E1,$E3,$F2,$7F,$0F,$00,$0F,$0F,$06,$4D
 .db $C1,$E0,$FC,$38,$14,$1E,$F8,$03,$F0,$F2,$F4,$1F,$C9,$C1,$C3,$E3
 .db $07,$F8,$00,$7C,$3C,$3E,$01,$B1,$F8,$78,$78,$3F,$F8,$7F,$64,$0D
 .db $F9,$81,$E0,$F8,$4C,$18,$1E,$18,$00,$6F,$F0,$78,$FF,$FF,$F8,$7C
 .db $3C,$07,$FF,$0F,$C3,$C7,$C2,$00,$E8,$1C,$02,$E7,$C3,$F0,$7C,$FF
 .db $A1,$F0,$78,$3C,$7E,$A2,$60,$F8,$F8,$10,$78,$38,$3A,$0C,$7C,$0F
 .db $E3,$E0,$FF,$F0,$78,$F9,$81,$F4,$03,$87,$8E,$03,$C1,$F0,$7E,$02
 .db $1E,$4F,$E3,$FC,$7F,$83,$F4,$70,$F0,$78,$3C,$1A,$16,$06,$01,$E0
 .db $FF,$C1,$7E,$0F,$1F,$BC,$0E,$0F,$17,$07,$8F,$B0,$3E,$0C,$06,$18
 .db $0E,$20,$7F,$09,$F0,$F8,$7F,$F0,$13,$8F,$87,$8F,$07,$83,$CF,$80
 .db $0C,$0E,$0F,$1C,$1F,$0F,$BE,$77,$3F,$C0,$F8,$3E,$3C,$3E,$1E,$04
 .db $E8,$70,$00,$70,$78,$7C,$78,$7C,$3F,$78,$3E,$3F,$81,$F0,$7C,$38
 .db $70,$70,$E0,$F0,$78,$13,$3C,$FC,$0E,$1B,$3F,$3C,$30,$78,$7C,$70
 .db $7E,$04,$3E,$08,$0E,$00,$60,$78,$65,$F8,$78,$3F,$FC,$78,$60,$FC
 .db $E0,$F1,$F8,$60,$78,$30,$48,$00,$F0,$F0,$F0,$F8,$F9,$B3,$E1,$C3
 .db $C0,$FF,$83,$3C,$F0,$36,$2C,$20,$07,$00,$77,$E2,$17,$FC,$0F,$97
 .db $6F,$83,$C3,$99,$C7,$8F,$86,$03,$83,$8E,$07,$07,$C7,$F9,$E1,$FE
 .db $0F,$C7,$81,$C0,$C3,$FC,$3E,$F8,$3E,$00,$00,$00,$03,$07,$FF,$06
 .db $7E,$0F,$87,$D7,$30,$64,$5E,$1F,$C0,$FE,$00,$E0,$E0,$40,$00,$7E
 .db $1B,$93,$0F,$C3,$C3,$F4,$1F,$0E,$0F,$83,$80,$38,$3E,$02,$4C,$18
 .db $38,$1F,$0F,$87,$CF,$9F,$FB,$BF,$0E,$0F,$87,$C3,$80,$1C,$3C,$0E
 .db $01,$80,$3F,$0E,$0F,$8F,$C1,$F0,$FC,$78,$FE,$0F,$03,$FF,$07,$00
 .db $F0,$0F,$00,$1B,$1E,$30,$7E,$1F,$37,$EF,$C7,$E0,$FB,$FC,$60,$7F
 .db $1F,$80,$12,$0C,$00,$3F,$07,$83,$E0,$F9,$F0,$FF,$C1,$81,$FF,$FF
 .db $30,$7C,$6C,$00,$40,$40,$30,$F0,$E0,$F1,$F1,$F0,$79,$FF,$E4,$1B
 .db $9F,$F8,$11,$A3,$C0,$E1,$80,$00,$CF,$07,$86,$1F,$BF,$0E,$1E,$FF
 .db $F0,$7D,$BC,$FC,$7D,$80,$00,$78,$00,$C0,$7F,$F0,$F0,$FC,$F9,$F0
 .db $FC,$07,$F0,$7F,$03,$C1,$E8,$03,$C0,$F8,$0D,$80,$FC,$1F,$B3,$FC
 .db $3F,$E3,$F3,$A7,$C3,$F0,$3E,$1F,$24,$0C,$00,$60,$70,$38,$F1,$7E
 .db $FD,$80,$7C,$7B,$3E,$7C,$3F,$0F,$B0,$60,$00,$20,$C8,$17,$45,$DD
 .db $0F,$3F,$B8,$0E,$0F,$FF,$FE,$E0,$78,$7C,$0E,$08,$06,$CC,$00,$04
 .db $9F,$F0,$7F,$FB,$7C,$3F,$CD,$F9,$37,$C7,$1F,$E7,$80,$00,$0F,$86
 .db $00,$03,$FE,$7C,$FE,$0C,$7F,$37,$7E,$5D,$3F,$9E,$41,$20,$40,$00
 .db $3E,$1F,$01,$04,$DD,$E7,$F8,$38,$3F,$FE,$3F,$01,$F8,$F8,$00,$08
 .db $18,$00,$7C,$1C,$05,$C8,$FF,$F1,$F8,$3C,$78,$FC,$3C,$01,$FD,$FE
 .db $60,$20,$02,$C0,$E0,$22,$11,$F9,$83,$F0,$F0,$F0,$F8,$7F,$F3,$E1
 .db $FE,$E1,$F0,$00,$20,$78,$3C,$00,$38,$3C,$7A,$7C,$18,$FF,$FC,$1F
 .db $CF,$1F,$33,$0E,$1E,$06,$0E,$04,$07,$1F,$0F,$8F,$1F,$8E,$07,$BF
 .db $8F,$9F,$BF,$C7,$E0,$01,$80,$00,$23,$C0,$90,$7F,$C1,$DC,$3F,$66
 .db $1F,$7F,$E0,$FC,$1D,$F9,$F0,$01,$C0,$10,$02,$E0,$70,$7E,$30,$FC
 .db $FF,$3C,$FF,$EF,$81,$F0,$FD,$DF,$00,$83,$00,$00,$83,$03,$C9,$FB
 .db $A7,$F1,$FB,$A3,$E5,$C7,$E3,$E1,$CF,$E0,$C0,$80,$00,$70,$E0,$10
 .db $79,$96,$3E,$21,$D2,$7E,$7C,$DF,$3E,$3F,$FA,$1E,$19,$06,$06,$39
 .db $00,$1E,$17,$1E,$1F,$1F,$1F,$1F,$3F,$0E,$3F,$FB,$7E,$04,$06,$00
 .db $1C,$00,$02,$7E,$77,$F0,$7C,$76,$4E,$EE,$FE,$FF,$FF,$FC,$18,$00
 .db $38,$10,$20,$4C,$1C,$23,$F8,$19,$F3,$FC,$FC,$77,$F8,$3C,$FF,$F8
 .db $00,$07,$81,$80,$07,$60,$40,$7E,$C1,$7F,$FF,$07,$1E,$7F,$8F,$8F
 .db $FF,$98,$00,$60,$00,$00,$00,$7C,$3F,$F4,$03,$FF,$8C,$87,$FF,$B9
 .db $FD,$FF,$F0,$01,$E0,$06,$60,$30,$04,$0F,$F8,$08,$1F,$F7,$79,$F3
 .db $FE,$7B,$3F,$E0,$C0,$7C,$00,$06,$1C,$00,$00,$FF,$F0,$80,$FC,$7F
 .db $F8,$FC,$FF,$FF,$FC,$00,$23,$00,$00,$20,$39,$FC,$04,$1E,$3F,$FF
 .db $03,$FF,$FF,$80,$F3,$FF,$98,$00,$0C,$00,$00,$00,$06,$E0,$78,$83
 .db $E7,$FF,$8F,$C7,$FF,$FF,$81,$FF,$F8,$00,$00,$08,$00,$10,$1F,$05
 .db $FF,$C3,$E3,$FF,$FE,$1F,$FF,$FF,$08,$37,$C0,$00,$00,$00,$01,$E0
 .db $00,$03,$FF,$C0,$0F,$F1,$FF,$FF,$FF,$FF,$8F,$E0,$40,$00,$E0,$00
 .db $00,$20,$98,$07,$F3,$F9,$E1,$F0,$FF,$FF,$E3,$FE,$1F,$F9,$00,$00
 .db $00,$00,$00,$01,$F0,$1D,$FB,$F1,$FE,$07,$FF,$FF,$EF,$C0,$FF,$3E
 .db $00,$00,$00,$00,$0C,$00,$01,$FE,$07,$83,$FF,$1F,$FF,$FF,$9F,$03
 .db $FE,$02,$00,$00,$00,$0F,$E0,$00,$07,$FE,$80,$FF,$F9,$FF,$FF,$FD
 .db $FF,$7F,$F8,$00,$1A,$00,$01,$B3,$20,$00,$3E,$0E,$CF,$FF,$3F,$FF
 .db $FE,$1C,$08,$FE,$00,$00,$18,$00,$1C,$00,$04,$02,$3F,$03,$7F,$FC
 .db $FF,$FF,$FC,$78,$7C,$FC,$00,$00,$00,$00,$F8,$00,$00,$7B,$F3,$C3
 .db $FF,$FF,$FF,$F9,$FF,$83,$F0,$08,$00,$00,$0F,$0F,$C0,$00,$07,$8F
 .db $1C,$9F,$FF,$FF,$FE,$FC,$30,$3F,$80,$00,$0A,$06,$80,$00,$0F,$00
 .db $1F,$97,$FF,$FE,$1F,$FF,$06,$3F,$C3,$FF,$00,$00,$00,$1F,$A0,$00
 .db $3A,$07,$FE,$30,$FF,$F7,$FF,$C0,$01,$F8,$F8,$00,$0B,$F0,$01,$FF
 .db $E0,$01,$C0,$F1,$E0,$FF,$FC,$7F,$FF,$80,$80,$07,$FE,$00,$07,$C0
 .db $00,$00,$07,$F0,$01,$F4,$70,$FF,$FF,$FF,$CF,$8F,$E0,$7F,$F8,$00
 .db $1C,$1F,$F0,$00,$39,$80,$FE,$38,$1F,$FF,$FF,$FC,$CC,$7C,$0C,$FC
 .db $10,$0C,$00,$1F,$10,$00,$FC,$38,$7C,$2F,$FF,$FF,$FC,$F8,$10,$FE
 .db $38,$1E,$0E,$00,$00,$7C,$20,$00,$1E,$06,$3F,$0F,$FF,$FF,$FE,$00
 .db $1F,$FF,$18,$06,$1C,$B8,$00,$3F,$00,$04,$08,$00,$FF,$FF,$FF,$FD
 .db $FF,$80,$1F,$FE,$00,$00,$78,$78,$60,$38,$60,$70,$F0,$78,$F8,$FD
 .db $FC,$78,$FE,$E0,$61,$F8,$F0,$E0,$61,$F0,$00,$80,$01,$F1,$E1,$F3
 .db $F3,$F7,$F1,$C3,$E3,$E3,$C1,$E1,$E3,$C0,$C3,$C0,$01,$C0,$03,$FF
 .db $C3,$E3,$F7,$FF,$E1,$8F,$C3,$03,$E2,$01,$E3,$60,$E4,$00,$30,$00
 .db $06,$7F,$8E,$7F,$FF,$FF,$F8,$7E,$01,$0F,$E3,$01,$C3,$E3,$80,$00
 .db $03,$84,$0F,$CF,$CF,$FF,$EF,$FF,$FC,$1E,$38,$7F,$F8,$00,$F0,$30
 .db $70,$00,$00,$F8,$FC,$F8,$7F,$FF,$E0,$FE,$78,$0F,$FF,$81,$03,$F7
 .db $E0,$00,$1F,$80,$03,$8F,$87,$8F,$FF,$FF,$5F,$FF,$00,$0F,$FC,$C0
 .db $71,$F0,$E0,$20,$00,$00,$63,$E0,$C1,$FF,$F1,$E1,$F5,$E3,$C1,$C7
 .db $CF,$87,$06,$07,$0C,$38,$20,$30,$70,$F8,$81,$FF,$E7,$E7,$C3,$E7
 .db $81,$C7,$D7,$03,$C7,$07,$8F,$06,$0E,$1E,$1E,$3C,$3D,$F8,$73,$FD
 .db $81,$E7,$8F,$83,$1F,$76,$00,$01,$E0,$00,$F8,$00,$7F,$FF,$F9,$FF
 .db $F7,$C3,$C7,$E7,$07,$BE,$0C,$1C,$1E,$00,$0C,$3C,$18,$3C,$FC,$31
 .db $FF,$F1,$F0,$E3,$E0,$C3,$FF,$83,$03,$9F,$03,$00,$0C,$8E,$06,$FC
 .db $3F,$FF,$F8,$F0,$F0,$F0,$C9,$03,$F0,$C1,$F4,$C0,$06,$01,$18,$20
 .db $7F,$FF,$0F,$FF,$C6,$1F,$C1,$81,$D8,$1F,$1A,$6F,$0F,$00,$1F,$00
 .db $1C,$18,$7F,$3E,$7C,$F9,$F0,$FB,$E0,$1D,$F0,$00,$F0,$F8,$78,$C1
 .db $83,$80,$13,$E1,$07,$C7,$87,$EF,$8F,$FF,$0F,$1F,$00,$0F,$7E,$00
 .db $7E,$00,$07,$90,$38,$78,$FC,$38,$7D,$FC,$E0,$F9,$E0,$49,$C1,$07
 .db $C1,$C3,$E0,$00,$7B,$80,$07,$FF,$7F,$8F,$DF,$F8,$3F,$FF,$80,$1E
 .db $3F,$00,$FE,$F8,$00,$2D,$F0,$00,$9F,$F6,$00,$7F,$F8,$0B,$FF,$C0
 .db $00,$FF,$00,$03,$FF,$80,$07,$AE,$00,$03,$D8,$2F,$F9,$F8,$70,$7F
 .db $FC,$07,$00,$00,$F1,$E6,$0E,$03,$E7,$C0,$0D,$FC,$1F,$9F,$1F,$FF
 .db $E3,$FF,$E0,$07,$E0,$07,$FC,$07,$C0,$00,$3E,$00,$01,$F0,$7F,$3F
 .db $0F,$FF,$1F,$FF,$80,$00,$7C,$0F,$C3,$87,$80,$03,$C0,$08,$3D,$F3
 .db $FF,$7F,$FF,$F9,$FD,$F0,$00,$60,$0E,$00,$E0,$40,$07,$1E,$00,$03
 .db $FF,$BC,$3C,$7F,$FF,$7F,$FC,$00,$00,$FE,$00,$3C,$10,$60,$78,$00
 .db $00,$13,$FF,$FC,$3F,$FF,$E7,$FF,$04,$0F,$F0,$78,$00,$FE,$18,$07
 .db $04,$00,$0F,$F7,$E1,$7F,$FF,$CE,$7F,$80,$00,$01,$F8,$20,$38,$FB
 .db $01,$E0,$C0,$40,$7F,$EF,$3F,$FF,$3F,$FF,$FF,$80,$03,$0F,$0C,$03
 .db $FC,$3C,$1E,$00,$00,$1F,$8F,$E0,$7F,$FF,$FF,$FE,$3E,$00,$30,$F0
 .db $04,$2F,$C0,$07,$00,$00,$00,$7F,$FC,$27,$FF,$FF,$DF,$FC,$1C,$03
 .db $F8,$00,$0F,$3F,$00,$09,$80,$00,$70,$EF,$F8,$3F,$FE,$3F,$FF,$F8
 .db $70,$0E,$20,$00,$7F,$80,$20,$20,$00,$00,$0F,$1F,$C0,$7F,$FC,$7F
 .db $FF,$F1,$E0,$0F,$F8,$00,$1F,$E0,$00,$7C,$00,$00,$3F,$FB,$83,$FF
 .db $F9,$CF,$FF,$F0,$02,$3C,$80,$E7,$8C,$00,$C3,$06,$20,$03,$DF,$79
 .db $E3,$DF,$3F,$F3,$8F,$F8,$20,$0C,$43,$F0,$31,$42,$08,$06,$03,$08
 .db $73,$EF,$9E,$E1,$FF,$8E,$77,$83,$0E,$70,$C7,$CF,$70,$03,$0F,$00
 .db $01,$07,$16,$7F,$9F,$8F,$0F,$3F,$9E,$06,$1F,$8C,$0F,$0D,$C3,$00
 .db $1F,$82,$06,$1F,$E3,$0F,$3F,$F3,$C7,$BF,$F0,$82,$1F,$99,$87,$BF
 .db $21,$C3,$8E,$30,$03,$0F,$78,$03,$FF,$88,$E7,$FF,$DC,$01,$3F,$98
 .db $01,$FF,$80,$21,$F6,$04,$01,$FF,$E4,$09,$FF,$C0,$1F,$FF,$92,$10
 .db $FF,$80,$03,$FF,$00,$06,$FC,$00,$03,$F3,$F8,$1F,$FF,$00,$7F,$FF
 .db $00,$27,$E6,$C0,$61,$FF,$00,$08,$04,$00,$09,$E1,$9C,$BF,$FF,$D8
 .db $7F,$F9,$80,$3C,$80,$1C,$EC,$77,$B0,$00,$C0,$00,$64,$C3,$98,$FC
 .db $7F,$F8,$67,$FF,$F0,$40,$78,$FE,$E0,$0F,$7C,$00,$00,$00,$CF,$80
 .db $FF,$F0,$3F,$FF,$CB,$FF,$AF,$E0,$03,$FF,$C0,$0C,$1C,$00,$00,$09
 .db $BE,$3E,$FB,$E2,$7F,$FC,$0E,$FD,$EC,$C0,$F3,$BF,$80,$08,$00,$02
 .db $40,$01,$C7,$FF,$FC,$C5,$FF,$F8,$C3,$D8,$1D,$BC,$19,$87,$00,$00
 .db $00,$01,$F0,$9E,$7C,$FF,$FE,$1F,$FF,$FE,$03,$C0,$7C,$FF,$1F,$F0
 .db $00,$00,$00,$03,$3F,$F0,$DF,$FF,$F0,$FF,$FF,$E0,$1F,$BF,$87,$FF
 .db $FE,$00,$00,$00,$00,$0D,$FF,$9F,$FF,$FF,$0F,$FF,$FE,$02,$7F,$FC
 .db $3E,$7F,$FC,$00,$00,$00,$00,$3B,$F8,$7F,$FF,$FC,$3F,$FF,$F0,$00
 .db $FF,$F8,$10,$5F,$C0,$00,$04,$00,$00,$FF,$BC,$1B,$FF,$F8,$7F,$FF
 .db $F8,$1F,$EF,$80,$70,$FE,$00,$00,$30,$00,$01,$FF,$E0,$63,$FF,$E2
 .db $FF,$FF,$00,$FF,$FE,$03,$8F,$F8,$00,$00,$00,$00,$1D,$FF,$1C,$7F
 .db $F8,$0F,$FF,$FB,$00,$FF,$FC,$03,$0F,$E8,$00,$00,$00,$06,$0F,$FC
 .db $07,$FF,$E0,$3F,$FF,$FC,$1F,$FF,$F0,$78,$78,$00,$1C,$00,$00,$3F
 .db $FF,$C0,$43,$FF,$03,$FF,$F9,$7F,$FF,$FC,$03,$F8,$00,$03,$C0,$00
 .db $00,$F8,$FC,$00,$3F,$7F,$07,$FF,$FB,$83,$F1,$F0,$7E,$08,$30,$00
 .db $00,$00,$00,$C0,$DF,$FC,$0F,$C6,$FF,$FF,$80,$FF,$07,$80,$FC,$07
 .db $03,$81,$00,$00,$EF,$C1,$F0,$7E,$F8,$0E,$DF,$F0,$7F,$0F,$E0,$3E
 .db $1F,$1E,$06,$03,$40,$0E,$07,$E8,$09,$FC,$3F,$7F,$F0,$7F,$F3,$7F
 .db $FC,$00,$FC,$08,$00,$00,$00,$1F,$E0,$FC,$3F,$B3,$27,$CD,$FE,$07
 .db $8F,$C1,$FF,$C0,$1F,$30,$30,$38,$08,$7F,$FC,$60,$18,$18,$1F,$FF
 .db $89,$FF,$7E,$3E,$5B,$F0,$30,$1F,$C0,$C0,$70,$6F,$3F,$83,$F0,$FC
 .db $FF,$FF,$3C,$1C,$3C,$0F,$F0,$7F,$D0,$BF,$F2,$00,$C0,$00,$78,$07
 .db $0B,$FD,$FF,$FF,$87,$80,$70,$7E,$7F,$F8,$80,$0C,$01,$F0,$3F,$CD
 .db $F0,$7F,$E0,$6F,$CD,$F0,$3F,$06,$C0,$FF,$3F,$FF,$40,$04,$03,$F7
 .db $F3,$E0,$7C,$00,$CF,$F0,$0F,$F0,$3F,$E7,$C0,$03,$F0,$10,$00,$00
 .db $1F,$E7,$FF,$81,$C0,$30,$03,$F8,$F0,$30,$3E,$3F,$3F,$1F,$1F,$07
 .db $87,$80,$1E,$03,$F0,$F8,$3E,$0F,$1F,$9F,$F3,$03,$CC,$DF,$BF,$86
 .db $00,$03,$C0,$07,$D9,$FF,$0F,$CF,$FF,$81,$F0,$40,$01,$F8,$0F,$CF
 .db $FF,$FE,$00,$00,$07,$87,$FF,$0F,$C0,$7F,$E3,$FD,$9F,$F8,$3D,$9F
 .db $E0,$7F,$C0,$C8,$07,$83,$C0,$7F,$BF,$FC,$01,$C0,$FF,$FF,$C0,$F0
 .db $03,$C1,$E1,$E1,$F8,$7F,$81,$F8,$60,$00,$01,$80,$E0,$7F,$8F,$FF
 .db $FD,$E0,$81,$C3,$83,$FE,$02,$83,$C2,$C3,$A1,$FC,$60,$7E,$0F,$87
 .db $80,$1F,$82,$07,$E7,$E0,$FC,$3F,$00,$C0,$01,$E0,$38,$16,$80,$7E
 .db $07,$0F,$8F,$FB,$EC,$FC,$37,$F8,$1C,$07,$01,$C1,$80,$FC,$7E,$83
 .db $E0,$7C,$03,$E6,$07,$0F,$E0,$FF,$03,$F8,$1F,$07,$C2,$07,$C1,$E0
 .db $2C,$07,$83,$9F,$07,$E7,$FF,$FC,$0F,$1E,$1E,$18,$F0,$78,$63,$E1
 .db $CF,$07,$03,$F8,$3F,$F0,$30,$61,$C1,$F0,$F1,$E3,$FF,$C3,$C3,$E1
 .db $E7,$83,$81,$83,$83,$E1,$E1,$E1,$E1,$F8,$74,$7D,$FC,$78,$7C,$3C
 .db $3C,$1E,$1C,$1F,$1F,$01,$C3,$9F,$C0,$E0,$70,$70,$7C,$1F,$07,$8F
 .db $9F,$E1,$FC,$F8,$E0,$3E,$07,$03,$83,$87,$E0,$F8,$3E,$0E,$1F,$81
 .db $C3,$BC,$1E,$7F,$87,$C7,$F0,$7C,$3E,$0F,$0F,$C0,$C1,$F0,$1C,$1F
 .db $07,$FF,$E1,$F8,$3F,$3F,$FE,$03,$C1,$F0,$3E,$7E,$0F,$07,$80,$F0
 .db $38,$3C,$3E,$0F,$87,$F0,$FF,$F8,$7E,$3F,$8F,$D9,$81,$F8,$7C,$00
 .db $1C,$0F,$07,$C0,$F0,$F4,$3E,$0F,$87,$C7,$F0,$F0,$F0,$3C,$1E,$07
 .db $8F,$E1,$F0,$3C,$1C,$3E,$02,$00,$39,$F8,$FE,$3E,$0F,$0F,$FB,$E0
 .db $7C,$3E,$07,$03,$C1,$E0,$70,$1C,$1E,$0F,$86,$40,$F8,$7C,$3C,$0F
 .db $FF,$F0,$F8,$78,$3C,$1F,$83,$81,$F0,$FE,$04,$07,$C1,$C0,$F0,$7C
 .db $3F,$9F,$8F,$FB,$F0,$F8,$00,$07,$F0,$E1,$E0,$1E,$07,$C1,$C0,$F0
 .db $1E,$1F,$C1,$FB,$F8,$FC,$3F,$0F,$FF,$30,$0B,$F7,$0E,$00,$81,$FB
 .db $40,$1E,$05,$C3,$FF,$EC,$BF,$1F,$87,$C0,$F9,$36,$40,$1F,$0F,$01
 .db $E0,$18,$1C,$01,$03,$80,$F9,$FC,$1F,$C1,$C1,$F8,$F1,$3E,$0F,$21
 .db $F0,$F0,$3C,$38,$07,$03,$81,$E0,$FF,$FE,$1F,$87,$83,$F3,$FE,$1C
 .db $82,$03,$BF,$E0,$F8,$3E,$1F,$03,$03,$C0,$F8,$7E,$0F,$0F,$87,$C7
 .db $F7,$04,$1C,$0F,$0F,$C7,$C0,$20,$7C,$0F,$01,$C0,$E0,$3F,$FE,$1F
 .db $C3,$F9,$FC,$03,$F0,$13,$C0,$F8,$16,$07,$C0,$1F,$C0,$FC,$08,$0F
 .db $F8,$3F,$C0,$FC,$3F,$E0,$F8,$7F,$01,$F8,$10,$30,$18,$07,$80,$68
 .db $0F,$38,$7F,$E0,$FC,$38,$0F,$F8,$1F,$C3,$C0,$3F,$F7,$70,$1E,$00
 .db $F0,$18,$03,$00,$5F,$F8,$78,$2F,$CF,$9E,$38,$F8,$3C,$1F,$E7,$03
 .db $C0,$BC,$1C,$0E,$0F,$07,$F0,$FC,$18,$3F,$E4,$C0,$BF,$1C,$1C,$1F
 .db $3C,$3C,$1F,$C0,$38,$30,$30,$1C,$7C,$79,$E1,$F8,$7E,$7D,$FF,$80
 .db $E0,$63,$82,$30,$6F,$00,$F8,$3D,$81,$E0,$2C,$70,$F1,$7E,$30,$E1
 .db $F7,$00,$F0,$7F,$87,$E3,$F7,$06,$4C,$0C,$06,$00,$60,$7C,$1E,$3F
 .db $F3,$C1,$F8,$38,$1C,$19,$01,$E3,$C3,$EF,$87,$C3,$C1,$07,$80,$C0
 .db $88,$1F,$3F,$81,$B3,$FF,$83,$FC,$3B,$3C,$1F,$03,$D8,$1C,$18,$10
 .db $24,$0E,$5B,$FF,$3F,$38,$FC,$1E,$07,$19,$80,$80,$FE,$3F,$3F,$FE
 .db $07,$F0,$00,$0C,$00,$0E,$06,$71,$FC,$3F,$FE,$FF,$C1,$F0,$3C,$40
 .db $F9,$FE,$00,$70,$F8,$10,$31,$C0,$00,$78,$FC,$1F,$3C,$F0,$7C,$80
 .db $78,$7C,$1F,$1F,$FF,$E0,$30,$02,$00,$00,$03,$00,$3E,$7F,$FF,$83
 .db $F9,$F8,$1C,$03,$C7,$80,$FF,$FC,$0F,$0F,$A7,$C0,$00,$80,$00,$07
 .db $FB,$C1,$FB,$FF,$E3,$C7,$E3,$C0,$30,$FF,$80,$01,$F0,$00,$F0,$E0
 .db $07,$C3,$FC,$CF,$F8,$7E,$07,$F9,$F0,$01,$F8,$3B,$FF,$F0,$70,$38
 .db $78,$00,$00,$F8,$10,$0F,$F0,$7E,$7E,$FF,$1E,$0F,$E0,$C0,$7D,$F0
 .db $00,$C7,$C0,$03,$81,$80,$03,$8F,$9F,$83,$FF,$30,$07,$CF,$30,$CE
 .db $3F,$E3,$EE,$F8,$03,$00,$80,$00,$0E,$0F,$C7,$F8,$FC,$F8,$13,$F0
 .db $E0,$63,$43,$C0,$3F,$F0,$01,$E1,$C3,$80,$07,$E0,$40,$FC,$7C,$7C
 .db $37,$F8,$FC,$60,$7E,$04,$3D,$FC,$1C,$00,$1F,$00,$01,$C0,$39,$F8
 .db $7F,$FE,$EE,$C0,$FE,$00,$1F,$30,$73,$F1,$FC,$00,$3F,$80,$1C,$01
 .db $F9,$C0,$0F,$F0,$FE,$47,$FF,$76,$47,$C0,$0F,$03,$FF,$00,$80,$00
 .db $07,$80,$C3,$F0,$3E,$0F,$FF,$F0,$FF,$E8,$FF,$01,$CE,$30,$0F,$CC
 .db $7C,$00,$EC,$06,$00,$01,$07,$81,$FE,$07,$07,$9F,$82,$6F,$9F,$83
 .db $80,$FF,$83,$83,$80,$02,$00,$C7,$C1,$E7,$CF,$FF,$F0,$3F,$C0,$CF
 .db $E3,$81,$FE,$07,$E0,$FE,$47,$80,$04,$03,$00,$1E,$07,$3F,$FF,$87
 .db $FE,$3F,$0F,$F8,$0F,$83,$E7,$FE,$04,$30,$04,$01,$00,$78,$07,$FE
 .db $3F,$E0,$FF,$F0,$03,$FF,$E0,$E0,$0E,$FF,$F1,$E0,$2C,$00,$09,$F0
 .db $30,$00,$FF,$DF,$1F,$FF,$FC,$70,$FA,$00,$F8,$00,$1F,$9B,$F0,$00
 .db $0C,$16,$70,$00,$09,$DF,$F8,$21,$FB,$87,$FF,$C2,$67,$0F,$EF,$40
 .db $00,$30,$00,$00,$06,$7A,$00,$FF,$2F,$E7,$FF,$B0,$0F,$FF,$00,$30
 .db $0F,$FF,$C0,$7E,$00,$1C,$00,$00,$00,$3F,$FC,$3E,$7F,$FF,$F0,$7F
 .db $FE,$20,$4C,$1F,$7F,$C0,$00,$00,$33,$00,$02,$2F,$FF,$EE,$C1,$FB
 .db $FE,$08,$DF,$C3,$9F,$FB,$FB,$FB,$E0,$00,$00,$00,$00,$04,$07,$FF
 .db $FF,$FD,$BF,$FF,$FA,$00,$01,$FF,$FC,$0C,$3F,$88,$00,$00,$04,$00
 .db $00,$87,$EF,$FF,$FF,$20,$7F,$FF,$C0,$0F,$FF,$F0,$00,$00,$00,$00
 .db $06,$00,$00,$FF,$FE,$0F,$FF,$FC,$03,$FF,$FC,$38,$0C,$3F,$DC,$E0
 .db $00,$CF,$10,$00,$00,$10,$3B,$FF,$00,$7F,$F3,$FC,$F8,$3F,$E9,$C0
 .db $C0,$30,$FE,$00,$00,$48,$C0,$20,$F0,$7F,$F6,$00,$FC,$F1,$FF,$FD
 .db $00,$7F,$FF,$E1,$00,$3F,$80,$00,$00,$02,$DF,$C2,$01,$FF,$FF,$EF
 .db $F0,$FF,$C3,$00,$38,$3F,$FF,$08,$03,$83,$B0,$00,$00,$3E,$0C,$3F
 .db $C1,$BF,$FE,$00,$07,$3F,$FC,$7F,$0F,$FC,$00,$00,$00,$38,$20,$00
 .db $1D,$FF,$F9,$BE,$3F,$F0,$EE,$18,$03,$FF,$F2,$00,$07,$FF,$C0,$00
 .db $0E,$00,$00,$00,$0F,$FF,$F8,$FE,$3F,$FF,$81,$80,$7F,$FF,$C8,$00
 .db $7F,$F0,$00,$00,$0F,$0F,$83,$F3,$FF,$FF,$FC,$01,$FF,$F3,$00,$63
 .db $FF,$F0,$01,$83,$C0,$80,$00,$03,$FF,$82,$00,$09,$FF,$FC,$7B,$1F
 .db $FF,$C0,$70,$BF,$E3,$C0,$06,$01,$FF,$04,$00,$2F,$9F,$1C,$3F,$1F
 .db $BE,$0E,$1C,$0E,$3E,$3E,$1C,$3E,$7C,$00,$18,$1E,$30,$38,$3E,$3E
 .db $F8,$1F,$9E,$3F,$7F,$81,$FE,$7F,$E7,$00,$00,$F3,$C0,$00,$6C,$E3
 .db $F0,$1F,$C9,$FE,$1F,$80,$3E,$1F,$C0,$4F,$03,$F9,$7C,$00,$FC,$80
 .db $C0,$10,$00,$FC,$0F,$B1,$FF,$8F,$E0,$3F,$C3,$FE,$07,$C0,$7F,$C1
 .db $E0,$0F,$00,$7C,$03,$9E,$1F,$30,$62,$07,$FF,$1F,$60,$FF,$87,$FC
 .db $1F,$E0,$FF,$06,$00,$3C,$41,$E0,$0F,$38,$FF,$E3,$FE,$3F,$80,$E0
 .db $03,$FE,$3F,$81,$F7,$0F,$F0,$18,$40,$7C,$0E,$00,$3F,$87,$FE,$3F
 .db $E1,$FF,$9F,$FC,$7E,$41,$E0,$07,$FB,$70,$03,$C0,$1C,$61,$E1,$1F
 .db $7E,$FC,$80,$0E,$3F,$61,$CE,$0F,$F9,$FF,$07,$C0,$18,$00,$00,$1F
 .db $F3,$FC,$1F,$F9,$FC,$0F,$F8,$7F,$2E,$F8,$0D,$03,$FC,$0C,$00,$7E
 .db $07,$C0,$7C,$07,$E0,$F8,$07,$FC,$7F,$83,$F0,$3F,$C1,$FA,$3F,$C1
 .db $F0,$00,$00,$F0,$0E,$00,$7F,$BF,$87,$FF,$9F,$00,$F8,$07,$13,$FE
 .db $1F,$C0,$FC,$06,$00,$7C,$07,$C0,$70,$03,$F8,$7F,$C7,$F1,$FF,$C7
 .db $F8,$7F,$07,$F0,$38,$03,$F8,$3E,$00,$80,$38,$03,$F8,$3F,$F7,$FC
 .db $3E,$07,$E8,$3C,$03,$FF,$FE,$07,$F8,$1C,$00,$00,$08,$03,$FC,$3F
 .db $03,$FE,$3F,$B7,$FC,$3E,$01,$F4,$1F,$00,$F0,$0E,$01,$F0,$0F,$10
 .db $E2,$0E,$00,$E3,$1F,$FF,$FF,$1F,$80,$F6,$0F,$D0,$F7,$06,$00,$3C
 .db $07,$00,$60,$07,$EC,$FF,$9F,$FC,$FF,$07,$80,$7F,$1F,$FC,$FE,$07
 .db $80,$E0,$0E,$00,$E0,$0F,$01,$FA,$1F,$81,$FA,$1F,$C1,$FE,$1F,$81
 .db $F0,$0F,$01,$F8,$1F,$01,$F0,$18,$03,$F8,$7F,$EF,$F8,$7F,$DF,$E0
 .db $FC,$0F,$E0,$FC,$1F,$C0,$E0,$00,$00,$40,$1F,$C3,$FC,$1F,$E1,$F8
 .db $3F,$03,$FC,$1F,$C1,$F0,$3C,$01,$C0,$0C,$01,$E0,$7F,$83,$C0,$11
 .db $87,$FE,$FF,$9F,$E0,$FE,$07,$C0,$F8,$0F,$C0,$38,$07,$00,$3E,$07
 .db $08,$FF,$0F,$FF,$FB,$0F,$C0,$FE,$1F,$8C,$FB,$06,$00,$10,$07,$00
 .db $7F,$1F,$80,$F1,$0F,$C0,$78,$0F,$FF,$FE,$0F,$E0,$F8,$03,$00,$F0
 .db $07,$C0,$78,$03,$C0,$70,$0F,$FF,$FF,$83,$FC,$FF,$83,$C0,$7D,$83
 .db $E6,$38,$C1,$C0,$18,$03,$C0,$3B,$EF,$C0,$3F,$C7,$80,$3F,$FF,$E0
 .db $7F,$C7,$C0,$3F,$01,$80,$10,$03,$E0,$1F,$C3,$C0,$3F,$FF,$E0,$3F
 .db $E3,$C0,$1C,$03,$E0,$1F,$E7,$C0,$1E,$60,$00,$1E,$00,$68,$1C,$7F
 .db $FF,$1F,$F8,$20,$1F,$FC,$3E,$1E,$10,$30,$04,$38,$38,$1F,$98,$38
 .db $7F,$FC,$3C,$1F,$38,$3E,$EF,$FC,$73,$E7,$90,$00,$07,$88,$01,$83
 .db $80,$00,$07,$CC,$7F,$C7,$FF,$FF,$C7,$FC,$20,$C3,$F0,$21,$81,$E0
 .db $70,$C0,$00,$30,$EF,$F8,$F0,$7E,$63,$F0,$7F,$FB,$FC,$7E,$3F,$E0
 .db $20,$30,$00,$00,$3C,$60,$3F,$FF,$F0,$F7,$7F,$E6,$0F,$FF,$F0,$03
 .db $EF,$C0,$C6,$FF,$C6,$00,$03,$C0,$00,$00,$00,$13,$FF,$EF,$FF,$F1
 .db $FF,$FE,$08,$7B,$FF,$C0,$00,$04,$08,$07,$09,$8F,$0F,$E7,$38,$E7
 .db $F1,$26,$00,$E7,$FF,$CF,$E3,$CF,$D9,$C0,$01,$80,$80,$01,$00,$00
 .db $37,$F7,$0F,$3F,$FF,$1F,$5F,$1C,$1E,$08,$1C,$3F,$F8,$20,$00,$F2
 .db $C0,$03,$E0,$07,$FF,$80,$07,$CF,$87,$FF,$27,$1F,$FF,$1C,$00,$7A
 .db $00,$00,$7E,$01,$07,$FC,$0F,$FF,$FC,$26,$3F,$FE,$00,$0F,$FC,$0F
 .db $EF,$80,$07,$C0,$C0,$00,$3D,$00,$07,$F3,$C3,$FF,$FF,$03,$FF,$84
 .db $07,$BF,$CC,$00,$3A,$00,$0F,$F0,$00,$1F,$F8,$BF,$BF,$87,$FE,$C7
 .db $CD,$D9,$FF,$83,$FF,$F0,$00,$70,$00,$0C,$F0,$00,$DD,$F3,$F1,$C9
 .db $FF,$F1,$CF,$E3,$01,$9F,$80,$1F,$4C,$0E,$B0,$06,$10,$00,$3C,$38
 .db $13,$9E,$0F,$BF,$F0,$FF,$E6,$F1,$CE,$07,$F3,$00,$0C,$20,$04,$81
 .db $00,$E3,$C0,$7F,$F0,$F3,$E7,$DF,$11,$C7,$F3,$CF,$03,$F0,$04,$6F
 .db $00,$0F,$02,$48,$20,$FF,$31,$CE,$7F,$86,$67,$F8,$E3,$C8,$3F,$C6
 .db $07,$DE,$00,$3F,$0C,$0E,$3C,$00,$0E,$3C,$1E,$E1,$9F,$F8,$B1,$FB
 .db $F0,$FF,$FB,$81,$03,$8E,$00,$06,$1E,$18,$3F,$3C,$38,$7F,$7E,$78
 .db $78,$F1,$F8,$F3,$FF,$C0,$CB,$01,$01,$8C,$06,$0F,$1F,$3F,$F6,$3E
 .db $FF,$4D,$FF,$B0,$8F,$C3,$CE,$07,$00,$1F,$20,$06,$7E,$04,$70,$3C
 .db $FF,$E8,$C3,$95,$E7,$3F,$FE,$1F,$C7,$FC,$1C,$06,$18,$40,$00,$0C
 .db $03,$83,$FF,$FF,$F8,$3E,$1F,$13,$E7,$C0,$01,$FF,$87,$83,$00,$43
 .db $04,$00,$00,$C6,$1F,$00,$3F,$FE,$07,$FF,$FC,$1F,$F8,$00,$FF,$F3
 .db $00,$03,$F0,$00,$70,$60,$41,$FF,$F8,$07,$FF,$F8,$24,$7D,$2C,$7F
 .db $FF,$E3,$E7,$07,$00,$07,$88,$00,$08,$38,$FF,$FE,$E3,$CF,$CF,$FE
 .db $39,$F8,$3E,$F6,$00,$C3,$C0,$C0,$1B,$08,$02,$1F,$07,$FE,$C7,$E1
 .db $FF,$EF,$F3,$FF,$CF,$04,$7F,$C1,$18,$00,$00,$00,$30,$00,$1F,$FF
 .db $EF,$E7,$F8,$F0,$7F,$C7,$C0,$3F,$18,$7E,$38,$00,$00,$00,$00,$00
 .db $1F,$CF,$87,$FF,$FF,$3F,$FF,$E4,$7C,$18,$00,$F0,$F0,$00,$00,$18
 .db $00,$70,$E0,$0F,$FF,$F8,$3F,$FF,$FC,$F1,$7F,$C0,$7D,$F6,$1F,$00
 .db $78,$00,$01,$80,$10,$07,$3F,$8E,$FF,$FF,$FC,$CF,$FF,$00,$EE,$7F
 .db $8E,$00,$3E,$00,$40,$18,$0C,$0E,$3F,$00,$FF,$BF,$F8,$FB,$FF,$03
 .db $FF,$87,$F6,$60,$C0,$00,$38,$00,$38,$00,$18,$0F,$FF,$FF,$FF,$FF
 .db $FE,$1F,$FE,$0D,$C0,$FB,$F0,$00,$00,$00,$00,$00,$00,$00,$7F,$FF
 .db $FB,$FF,$E1,$F7,$FF,$FC,$78,$4F,$F0,$BD,$00,$00,$00,$0C,$00,$29
 .db $F0,$FF,$FE,$F0,$FF,$FF,$DF,$FD,$43,$83,$70,$77,$F7,$00,$00,$00
 .db $40,$00,$07,$C0,$6F,$FF,$C7,$FF,$FF,$F9,$E0,$1B,$83,$81,$FF,$80
 .db $00,$03,$00,$00,$7F,$80,$1F,$FF,$00,$3F,$FF,$E1,$3B,$3F,$E0,$07
 .db $FF,$00,$21,$00,$00,$00,$9E,$00,$03,$FF,$FC,$3F,$FC,$5F,$FE,$40
 .db $7F,$6C,$1F,$22,$60,$00,$00,$00,$00,$19,$80,$03,$FF,$E3,$E4,$FF
 .db $FF,$C3,$B7,$E1,$C1,$7F,$E0,$07,$CE,$00,$80,$1F,$C6,$00,$7F,$C3
 .db $3F,$FC,$80,$3F,$FF,$FF,$90,$1F,$F8,$02,$F8,$00,$01,$C1,$00,$11
 .db $E0,$2C,$0F,$FF,$E0,$77,$F0,$9F,$FF,$80,$00,$FF,$FF,$E0,$04,$38
 .db $00,$3F,$00,$11,$FF,$FE,$38,$7F,$F7,$80,$FF,$C8,$00,$FE,$0F,$32
 .db $42,$00,$00,$7F,$18,$00,$7F,$06,$27,$FF,$1E,$7D,$FF,$0E,$0F,$FF
 .db $0C,$3C,$F8,$04,$1C,$78,$00,$08,$F0,$0E,$7F,$FD,$B2,$7F,$F8,$0C
 .db $67,$E3,$80,$FF,$C0,$00,$43,$C3,$00,$D8,$40,$0F,$0F,$FF,$85,$FF
 .db $F0,$1F,$FF,$E0,$0F,$9F,$00,$00,$19,$F0,$0C,$3E,$00,$0F,$F0,$F0
 .db $7E,$7E,$83,$DF,$FF,$C0,$E3,$FE,$01,$F8,$0F,$80,$00,$06,$00,$68
 .db $1F,$87,$FF,$87,$0F,$FC,$3F,$CF,$CC,$0F,$FF,$F9,$60,$00,$00,$00
 .db $1F,$E0,$40,$7C,$FC,$38,$7F,$FF,$F8,$7F,$F0,$30,$7F,$E7,$FC,$C0
 .db $40,$00,$00,$80,$00,$73,$F0,$7F,$FC,$7F,$C7,$C0,$FE,$03,$F9,$FF
 .db $8F,$FE,$00,$00,$C0,$08,$00,$C4,$0E,$0F,$FF,$FF,$8F,$FC,$1F,$1F
 .db $FF,$F0,$03,$F8,$60,$17,$80,$00,$06,$00,$00,$7F,$FF,$F8,$FF,$F3
 .db $80,$FF,$E3,$00,$7E,$0F,$83,$F9,$F0,$00,$00,$00,$00,$71,$FF,$B7
 .db $FC,$7E,$0F,$EF,$FF,$C7,$C0,$78,$1F,$F0,$30,$03,$00,$00,$07,$C0
 .db $78,$07,$FF,$7B,$FF,$FF,$F8,$1F,$F8,$00,$5F,$FF,$E0,$1C,$00,$00
 .db $38,$00,$00,$7F,$FF,$9F,$FF,$FF,$80,$7F,$E0,$0B,$FF,$FF,$C0,$F7
 .db $00,$00,$00,$F8,$03,$07,$81,$FF,$FF,$FC,$07,$9F,$E0,$1F,$FF,$F8
 .db $0F,$80,$01,$0E,$00,$00,$06,$00,$00,$1F,$FF,$E0,$7F,$F8,$0F,$FF
 .db $1C,$0F,$FF,$F8,$0F,$A0,$0C,$00,$00,$7C,$20,$1F,$FC,$01,$FF,$E0
 .db $1F,$FF,$FC,$03,$F0,$3F,$1F,$E0,$60,$00,$7C,$00,$00,$FF,$C1,$DF
 .db $99,$FF,$F0,$81,$FE,$3F,$F0,$0F,$C7,$FE,$0F,$00,$00,$07,$E1,$07
 .db $83,$E1,$BF,$80,$FF,$81,$C0,$3F,$C3,$FC,$3F,$E0,$C0,$F0,$00,$70
 .db $01,$C1,$F8,$3F,$C1,$FD,$E0,$C9,$3E,$0F,$80,$0F,$FF,$03,$FC,$03
 .db $C0,$0F,$F3,$C0,$3F,$01,$F9,$E7,$F1,$FE,$07,$F0,$FF,$00,$08,$3F
 .db $C1,$FF,$87,$00,$80,$E9,$80,$01,$FC,$7F,$F8,$1F,$E0,$1E,$0F,$F0
 .db $3F,$00,$F8,$03,$E1,$FE,$07,$F0,$7F,$00,$03,$02,$07,$DF,$C7,$FF
 .db $F1,$F8,$07,$C0,$1C,$01,$F3,$7F,$C1,$F8,$34,$01,$0F,$80,$7C,$0C
 .db $0F,$C1,$FE,$FE,$0F,$46,$CF,$C0,$16,$02,$64,$7F,$DB,$FE,$06,$C2
 .db $20,$03,$83,$82,$4E,$FF,$FF,$8F,$64,$8E,$0F,$80,$E0,$07,$41,$FF
 .db $F1,$FC,$FF,$40,$D8,$10,$60,$02,$3E,$7F,$FF,$30,$3F,$02,$00,$00
 .db $30,$0F,$FF,$0F,$CC,$7C,$3C,$00,$1C,$1C,$18,$1F,$FF,$CF,$BE,$1F
 .db $06,$C0,$38,$03,$00,$13,$F1,$FF,$BF,$FC,$38,$03,$00,$07,$C4,$1F
 .db $F9,$FC,$7C,$0F,$80,$30,$00,$01,$F0,$1F,$FE,$7F,$F3,$F8,$1F,$02
 .db $20,$1E,$07,$0F,$FF,$FF,$E0,$7C,$10,$0C,$00,$1E,$7C,$1F,$FF,$7F
 .db $FC,$3E,$00,$17,$80,$01,$F8,$3F,$FF,$03,$F1,$F0,$78,$3E,$01,$C0
 .db $7E,$03,$FF,$EF,$C3,$F0,$78,$00,$01,$80,$C1,$F8,$7E,$01,$F0,$70
 .db $00,$78,$00,$78,$E1,$F1,$FE,$74,$FD,$C3,$E0,$F8,$0E,$C1,$E0,$FF
 .db $F9,$F0,$FB,$C0,$80,$00,$00,$7E,$0F,$C7,$FA,$7F,$BE,$0E,$0F,$0E
 .db $0F,$86,$1E,$3E,$1E,$07,$F8,$3C,$0E,$00,$3C,$08,$3F,$FF,$FF,$FC
 .db $FC,$0F,$00,$30,$1F,$E0,$FC,$3E,$3E,$08,$40,$F0,$70,$0C,$FC,$32
 .db $7F,$F8,$FF,$3F,$F8,$43,$C0,$F0,$40,$00,$FF,$87,$E3,$E3,$F0,$00
 .db $E0,$0F,$83,$E1,$F9,$F8,$FF,$0F,$F0,$00,$70,$7D,$B2,$00,$FC,$90
 .db $3F,$03,$C8,$00,$F0,$3E,$01,$C1,$FF,$F8,$FF,$E1,$F0,$00,$0C,$30
 .db $38,$00,$F9,$F8,$1E,$08,$1E,$00,$78,$3F,$1F,$FE,$7F,$F8,$1F,$83
 .db $E1,$F0,$7E,$01,$81,$C0,$00,$FC,$6D,$E1,$E0,$00,$00,$3E,$01,$E1
 .db $F6,$FE,$1F,$EF,$07,$81,$FF,$1E,$03,$07,$83,$C0,$0F,$07,$83,$C0
 .db $FF,$C2,$0E,$07,$C3,$F9,$FF,$FF,$0F,$C1,$C1,$E0,$7C,$0E,$03,$E0
 .db $00,$F0,$0C,$03,$E1,$FC,$20,$7E,$7F,$E7,$F3,$FE,$38,$7D,$83,$C0
 .db $00,$1D,$D0,$3F,$C8,$D0,$00,$00,$01,$F9,$F8,$FE,$FE,$0F,$E0,$FC
 .db $40,$FF,$7E,$00,$78,$10,$64,$0E,$0D,$D8,$C0,$F8,$1E,$07,$E4,$FF
 .db $FF,$FF,$FC,$7F,$00,$7E,$0F,$80,$EE,$07,$E0,$78,$03,$00,$0F,$9F
 .db $E1,$FC,$7F,$07,$F8,$FF,$CF,$FC,$3C,$3C,$00,$0C,$01,$E0,$F0,$3C
 .db $08,$00,$07,$E1,$E0,$F9,$FB,$FE,$85,$E1,$E0,$F8,$FE,$7C,$01,$E0
 .db $60,$60,$38,$F8,$41,$81,$87,$C1,$F0,$F8,$7F,$F3,$FF,$CB,$F0,$7E
 .db $1F,$80,$1F,$F0,$0C,$00,$18,$18,$0F,$87,$EF,$90,$FE,$0C,$1F,$C7
 .db $FF,$FF,$FE,$0F,$8F,$80,$0F,$C0,$FC,$07,$80,$03,$01,$CF,$FF,$07
 .db $EF,$F8,$3F,$0F,$9F,$0F,$C1,$F8,$7E,$08,$00,$00,$09,$80,$CC,$0F
 .db $C0,$7F,$03,$C1,$FF,$7F,$C1,$BE,$0F,$C1,$F0,$3F,$80,$FC,$1F,$00
 .db $70,$00,$60,$7C,$1E,$3C,$01,$FF,$68,$F8,$7E,$1F,$FF,$FE,$00,$7C
 .db $08,$1F,$01,$F8,$3E,$00,$1C,$0F,$C0,$FC,$0F,$F3,$FC,$8F,$83,$E1
 .db $FF,$B3,$F0,$4F,$C0,$70,$00,$C1,$E0,$F3,$F0,$E0,$7E,$07,$E1,$FF
 .db $CF,$B8,$3E,$18,$F8,$78,$74,$38,$F8,$E0,$F0,$3C,$06,$70,$41,$FC
 .db $1F,$B0,$31,$C3,$F1,$FF,$C7,$F3,$E3,$E1,$E0,$07,$E3,$81,$E1,$88
 .db $27,$C3,$07,$C1,$F8,$C3,$DF,$87,$B1,$80,$FF,$CF,$1F,$F0,$7C,$03
 .db $F8,$03,$C3,$47,$8F,$01,$0F,$83,$60,$0F,$BF,$1F,$E0,$FF,$0E,$1E
 .db $3C,$0B,$FE,$0F,$30,$FC,$00,$1C,$01,$E0,$03,$F0,$71,$83,$FC,$77
 .db $03,$F8,$7F,$E0,$FC,$07,$4D,$E1,$83,$81,$F8,$38,$00,$70,$3E,$01
 .db $FE,$0F,$F8,$F8,$3F,$0F,$FF,$F0,$3F,$0F,$20,$04,$1A,$02,$03,$E0
 .db $FD,$87,$80,$06,$7C,$03,$F3,$E0,$1F,$FB,$F3,$E0,$FC,$3C,$1D,$02
 .db $7C,$F0,$0C,$0F,$18,$06,$3C,$0E,$3F,$01,$FE,$0F,$07,$FF,$1F,$B8
 .db $3F,$07,$C0,$33,$C7,$80,$00,$1B,$00,$03,$81,$E1,$F8,$3F,$FE,$03
 .db $D1,$FF,$1C,$7C,$3B,$02,$04,$0F,$C0,$7C,$06,$4C,$C1,$02,$0C,$3C
 .db $70,$7F,$E4,$5F,$E1,$FC,$07,$CF,$0E,$1C,$07,$C7,$A0,$08,$00,$F1
 .db $81,$D0,$0F,$D9,$8F,$0F,$E0,$F0,$FF,$DF,$3E,$77,$E0,$00,$6F,$83
 .db $C0,$43,$9E,$0F,$03,$C3,$C3,$8F,$CF,$83,$E7,$9F,$D8,$FF,$C3,$E0
 .db $C0,$01,$C1,$C1,$83,$C1,$F1,$E3,$81,$FF,$C1,$F1,$F7,$E3,$C7,$E1
 .db $FF,$BE,$C1,$C3,$83,$C1,$E6,$00,$07,$E0,$0F,$82,$0E,$07,$C0,$0E
 .db $0F,$0C,$1F,$87,$1F,$DF,$1F,$06,$1F,$07,$0F,$00,$0F,$01,$E2,$C1
 .db $0F,$C1,$D0,$07,$F9,$83,$FF,$C1,$FB,$FB,$F0,$2F,$00,$00,$F0,$01
 .db $F0,$7C,$38,$1F,$E0,$7C,$1A,$3F,$F8,$E3,$FC,$1F,$F3,$F8,$32,$73
 .db $80,$37,$C0,$22,$70,$37,$E0,$7C,$83,$F0,$30,$EF,$F0,$3F,$47,$FF
 .db $F0,$FF,$81,$F0,$0F,$81,$20,$5F,$01,$FC,$1F,$C2,$07,$F8,$07,$FE
 .db $1F,$1F,$07,$FE,$07,$FC,$1F,$00,$00,$3C,$01,$00,$0D,$98,$1F,$C0
 .db $1E,$07,$BF,$B8,$7E,$FE,$3F,$70,$3F,$98,$3E,$00,$1C,$3E,$18,$10
 .db $3C,$08,$3C,$03,$FC,$3B,$F1,$F2,$7F,$FF,$FA,$07,$F0,$E1,$C1,$08
 .db $C1,$E1,$E0,$03,$E1,$C0,$E0,$07,$E0,$F8,$37,$E6,$DF,$E3,$F0,$0F
 .db $E1,$F2,$00,$41,$FF,$80,$81,$E7,$81,$0E,$E0,$03,$8F,$C0,$CF,$CF
 .db $9F,$E7,$9B,$3F,$07,$0E,$0E,$70,$2F,$80,$0F,$1E,$00,$1D,$03,$FC
 .db $78,$E8,$1F,$EE,$3F,$FC,$77,$FF,$C0,$30,$00,$78,$3B,$E0,$13,$F0
 .db $00,$01,$10,$7E,$01,$FF,$DF,$FE,$FF,$E0,$07,$FE,$18,$01,$E0,$F9
 .db $00,$50,$60,$60,$2C,$60,$0E,$7F,$00,$3F,$F8,$7F,$FE,$30,$0F,$FC
 .db $0F,$00,$7E,$08,$C0,$1E,$18,$70,$03,$E0,$0F,$E0,$1F,$E7,$FF,$FC
 .db $C6,$0F,$80,$41,$00,$80,$7F,$E0,$0E,$19,$00,$00,$0F,$03,$F8,$C1
 .db $BF,$FF,$C3,$F7,$8F,$FF,$FC,$00,$70,$07,$E0,$41,$8C,$20,$20,$40
 .db $00,$7E,$06,$0F,$FF,$FD,$FF,$80,$1E,$FF,$70,$1F,$C3,$FE,$DC,$00
 .db $0C,$C8,$00,$01,$FF,$89,$80,$1F,$FD,$FF,$FE,$4E,$4F,$FC,$02,$00
 .db $CF,$BF,$FC,$0F,$BE,$00,$00,$00,$06,$F0,$0C,$FB,$FF,$00,$7C,$7F
 .db $DF,$FC,$0E,$06,$78,$F3,$80,$80,$78,$00,$00,$A1,$01,$E0,$03,$8F
 .db $FF,$E0,$E1,$FF,$FF,$01,$83,$C0,$7F,$9F,$00,$07,$80,$00,$07,$7E
 .db $80,$00,$FF,$FF,$F0,$FF,$0F,$FD,$F0,$00,$EF,$FC,$7D,$F1,$90,$18
 .db $00,$20,$0F,$F0,$D8,$03,$FF,$FF,$03,$FF,$FF,$FF,$F6,$03,$D8,$0F
 .db $03,$FE,$0F,$F0,$00,$02,$00,$0F,$00,$3F,$FF,$FC,$0F,$C6,$7E,$1F
 .db $C0,$1F,$EF,$FF,$0E,$00,$1E,$00,$00,$1F,$F0,$18,$00,$7F,$FF,$F0
 .db $7F,$FB,$F8,$7C,$00,$7F,$33,$F0,$FB,$E0,$F0,$00,$00,$01,$E0,$02
 .db $03,$FF,$FF,$01,$FF,$CF,$E7,$F2,$C3,$EF,$F0,$47,$87,$40,$FE,$00
 .db $00,$07,$00,$04,$0F,$FF,$F6,$03,$FF,$CF,$DF,$81,$8F,$FF,$C1,$8D
 .db $8F,$0D,$00,$00,$0F,$80,$00,$00,$0F,$FF,$EC,$07,$FF,$F8,$0F,$04
 .db $FC,$FF,$FC,$DF,$00,$70,$00,$00,$3F,$98,$00,$02,$1F,$FC,$08,$CF
 .db $FF,$FE,$3F,$C0,$DE,$00,$0F,$FC,$33,$00,$00,$00,$7F,$00,$00,$3F
 .db $FF,$F0,$0B,$07,$FC,$3F,$FF,$FF,$FF,$C0,$03,$E0,$00,$00,$00,$1F
 .db $F0,$00,$01,$FF,$FE,$1E,$3F,$FE,$F0,$3F,$F0,$78,$1F,$70,$FF,$B0
 .db $00,$00,$01,$F0,$00,$30,$6F,$FF,$FE,$00,$FF,$FF,$01,$FF,$FF,$80
 .db $07,$87,$FC,$00,$00,$00,$03,$FC,$00,$01,$FF,$DF,$FB,$03,$FF,$FE
 .db $0F,$9F,$FF,$86,$03,$0F,$FE,$00,$00,$00,$03,$E6,$00,$03,$FF,$FF
 .db $F7,$0F,$FF,$87,$03,$FF,$FF,$07,$FE,$1F,$B8,$00,$02,$00,$1E,$CF
 .db $C8,$0E,$FF,$00,$7C,$07,$FF,$FC,$3F,$FF,$F8,$00,$1C,$7F,$FC,$00
 .db $00,$18,$00,$00,$0E,$01,$FE,$3F,$F0,$38,$3F,$F8,$3F,$FF,$F0,$1C
 .db $7C,$11,$80,$00,$07,$F8,$01,$8C,$00,$00,$F0,$5F,$F1,$FF,$FF,$F0
 .db $1F,$F1,$00,$7F,$E7,$F0,$00,$00,$00,$20,$07,$FC,$FE,$07,$00,$FE
 .db $00,$01,$FF,$FF,$FF,$F8,$0F,$03,$F8,$00,$00,$80,$0C,$00,$70,$A0
 .db $C7,$0C,$3F,$EF,$C0,$27,$FF,$C7,$FF,$8F,$C0,$0E,$0F,$00,$00,$1F
 .db $00,$00,$7E,$07,$00,$7C,$FF,$F0,$3C,$FF,$F3,$FC,$7C,$3F,$F8,$7C
 .db $06,$00,$10,$01,$00,$7C,$3F,$E0,$20,$9F,$F1,$60,$7F,$FF,$F6,$FF
 .db $87,$C0,$1E,$07,$E0,$30,$00,$00,$00,$07,$07,$C0,$7F,$7F,$E0,$0F
 .db $FF,$FC,$7F,$FF,$FE,$3C,$00,$03,$80,$02,$01,$F0,$0E,$00,$40,$09
 .db $07,$FF,$3F,$FF,$FF,$F8,$3F,$63,$FE,$0C,$0F,$E0,$00,$00,$00,$00
 .db $03,$01,$F8,$0F,$07,$E0,$1E,$FF,$F8,$1F,$FF,$FC,$00,$07,$FF,$30
 .db $00,$0D,$00,$00,$05,$F8,$07,$FF,$FC,$C0,$1F,$FF,$DF,$FF,$D3,$C0
 .db $37,$03,$E0,$00,$0F,$E8,$00,$07,$C2,$00,$17,$FF,$FC,$1F,$FF,$C0
 .db $0F,$FF,$D0,$1F,$FF,$38,$00,$00,$EC,$00,$07,$80,$60,$41,$F8,$09
 .db $FF,$FE,$FF,$F4,$FF,$E0,$07,$83,$E3,$F9,$E0,$60,$3C,$00,$03,$FC
 .db $00,$5F,$DC,$7E,$E3,$FC,$11,$FF,$FC,$07,$CF,$83,$E0,$E1,$F0,$07
 .db $F8,$00,$3C,$01,$20,$13,$7F,$1F,$F7,$E1,$C0,$F3,$F8,$47,$C0,$F8
 .db $70,$F8,$18,$1F,$00,$18,$03,$9F,$80,$0F,$3F,$FF,$83,$F3,$F8,$7F
 .db $C0,$18,$3D,$FF,$C1,$3C,$1E,$0C,$00,$00,$88,$1E,$07,$C0,$FF,$FE
 .db $0F,$FF,$C7,$F3,$83,$C1,$F8,$13,$81,$F0,$3C,$00,$00,$07,$80,$E0
 .db $06,$39,$FF,$83,$F0,$FF,$84,$0B,$F0,$7C,$7F,$3F,$04,$40,$FC,$00
 .db $00,$0F,$30,$0C,$0D,$FE,$FD,$EF,$DF,$BF,$F0,$3E,$00,$3F,$8E,$66
 .db $FE,$07,$F0,$00,$00,$0F,$C0,$3C,$7E,$6B,$FF,$07,$F9,$FF,$C1,$83
 .db $E1,$FB,$C0,$F0,$FB,$C1,$F0,$30,$40,$E0,$03,$00,$FC,$FF,$F8,$7F
 .db $FF,$C1,$C0,$7C,$62,$FC,$F8,$20,$F8,$78,$40,$10,$00,$80,$30,$60
 .db $9D,$FF,$F9,$27,$FC,$F8,$01,$E3,$EF,$C1,$F8,$7F,$F8,$0D,$80,$03
 .db $01,$F0,$1C,$1F,$FC,$1F,$F1,$F7,$E1,$F8,$3E,$0F,$CF,$83,$CF,$0F
 .db $C0,$3C,$00,$00,$13,$03,$80,$FF,$3E,$7F,$D9,$FF,$07,$C0,$7F,$E3
 .db $E1,$FC,$C7,$CF,$90,$3C,$0E,$80,$70,$1F,$D8,$3E,$FF,$FB,$9F,$CF
 .db $02,$60,$F8,$1F,$C8,$7E,$1F,$9F,$40,$70,$00,$08,$1C,$3C,$30,$3D
 .db $FE,$78,$33,$F8,$F0,$37,$F9,$B0,$FE,$27,$E1,$E0,$C8,$C0,$70,$20
 .db $C0,$82,$4F,$0F,$E1,$FE,$6F,$B3,$3C,$3E,$7F,$E3,$F8,$9D,$F0,$F0
 .db $30,$80,$00,$03,$61,$C1,$FC,$1F,$F1,$3F,$1F,$07,$E1,$65,$8F,$C7
 .db $F8,$3F,$E0,$FE,$04,$08,$00,$70,$60,$70,$7C,$7F,$C7,$FF,$87,$C1
 .db $B3,$F0,$7F,$FC,$0E,$7F,$E0,$81,$80,$40,$01,$E0,$00,$3F,$F8,$3F
 .db $C7,$CF,$E6,$7E,$30,$FC,$1E,$7D,$F0,$FF,$00,$F0,$E1,$80,$09,$F0
 .db $0F,$1F,$F3,$FE,$3F,$3C,$7B,$F0,$7C,$F0,$FF,$86,$1E,$F9,$C0,$43
 .db $E0,$00,$1C,$1C,$0E,$1F,$F3,$E8,$FC,$FF,$E0,$C1,$FF,$01,$FF,$C7
 .db $8F,$8F,$00,$0C,$30,$00,$00,$04,$D8,$63,$E3,$F4,$7E,$9F,$C0,$3F
 .db $1F,$FE,$78,$76,$F8,$00,$48,$11,$00,$1E,$01,$A6,$FE,$CF,$F9,$FF
 .db $FB,$FF,$F1,$0B,$C0,$E3,$88,$FF,$FF,$00,$00,$00,$00,$01,$86,$F1
 .db $8F,$E7,$11,$FF,$FE,$1E,$03,$CF,$7F,$E0,$FC,$FC,$0E,$01,$C1,$80
 .db $00,$80,$0E,$06,$0F,$FF,$FF,$FF,$DE,$38,$00,$3F,$B2,$0C,$FF,$BE
 .db $F7,$00,$00,$00,$18,$00,$FF,$EF,$FE,$0F,$F0,$FE,$7F,$3E,$1F,$1E
 .db $F0,$31,$FF,$3F,$80,$00,$60,$00,$00,$00,$1E,$87,$ED,$FF,$FF,$F9
 .db $C3,$1E,$03,$9F,$F9,$BF,$FC,$7C,$00,$00,$00,$00,$00,$3F,$07,$FF
 .db $FF,$FE,$3F,$FE,$3E,$2F,$F2,$6E,$0F,$F8,$00,$FF,$81,$80,$00,$00
 .db $07,$0F,$0F,$C3,$FF,$FC,$3F,$F8,$F8,$03,$EF,$C3,$8F,$FF,$C3,$80
 .db $00,$00,$00,$00,$00,$7E,$3F,$0F,$FF,$FC,$7F,$F1,$F0,$1F,$3C,$D8
 .db $78,$2C,$F8,$30,$0F,$00,$00,$00,$00,$0C,$7F,$FF,$FF,$FF,$E7,$8F
 .db $80,$0F,$BE,$1F,$FE,$FC,$38,$00,$40,$00,$00,$00,$1F,$FF,$83,$FF
 .db $DB,$FF,$FF,$FF,$E0,$7E,$00,$71,$CF,$8F,$9E,$1E,$00,$00,$00,$08
 .db $01,$DF,$C7,$FF,$FF,$FC,$FF,$BF,$00,$1F,$FF,$8F,$8F,$F8,$60,$10
 .db $02,$00,$00,$07,$01,$E0,$FF,$F8,$EF,$FF,$87,$FF,$F0,$19,$1F,$04
 .db $1E,$7F,$C0,$20,$00,$00,$00,$00,$02,$C1,$C7,$FF,$FF,$E7,$FF,$87
 .db $03,$FA,$06,$0F,$BF,$03,$9C,$00,$00,$04,$00,$00,$7E,$01,$FF,$FF
 .db $CF,$1C,$FE,$21,$FB,$FF,$00,$01,$F8,$00,$60,$1E,$00,$00,$F0,$00
 .db $BC,$3F,$1F,$FF,$FC,$1F,$7E,$3E,$18,$38,$3E,$00,$7E,$3E,$00,$38
 .db $70,$00,$1F,$1C,$0E,$3C,$F9,$FF,$FF,$1E,$3F,$FC,$C0,$F8,$3E,$3E
 .db $00,$F3,$00,$70,$7C,$38,$00,$E0,$C0,$BD,$FF,$F8,$F9,$FB,$F6,$6C
 .db $F8,$E0,$E1,$C3,$3E,$30,$60,$E0,$03,$00,$1E,$03,$F1,$C3,$FF,$FE
 .db $3F,$FF,$FE,$0F,$97,$00,$7F,$83,$FC,$1E,$06,$00,$10,$01,$B8,$0F
 .db $DC,$F8,$7F,$FF,$F8,$7F,$F8,$20,$FF,$C6,$E0,$F4,$E0,$00,$0E,$01
 .db $C0,$C0,$C0,$C0,$3F,$FF,$C7,$FF,$F8,$BF,$FF,$0C,$0B,$1E,$00,$11
 .db $FE,$18,$18,$00,$00,$03,$FE,$18,$7F,$FF,$C9,$FF,$FC,$38,$3E,$0D
 .db $01,$8E,$DC,$30,$6C,$08,$00,$00,$18,$00,$7C,$E7,$1E,$7F,$FF,$FD
 .db $FF,$F0,$07,$CD,$FC,$00,$E1,$E0,$00,$30,$60,$00,$06,$40,$07,$FF
 .db $FC,$3F,$FF,$99,$3E,$F8,$1B,$3F,$3E,$01,$8E,$68,$78,$00,$00,$00
 .db $02,$67,$CE,$0D,$F3,$E0,$3F,$FF,$F3,$F0,$E3,$00,$7F,$80,$1C,$3F
 .db $E0,$00,$0D,$90,$00,$0C,$8F,$19,$FF,$FF,$FF,$CF,$C1,$F0,$0F,$FF
 .db $E0,$09,$B0,$00,$01,$80,$00,$18,$00,$00,$1F,$D9,$FD,$FF,$FF,$8F
 .db $FF,$F8,$01,$FC,$E0,$00,$7F,$FC,$60,$00,$00,$00,$04,$04,$1F,$FF
 .db $FC,$3F,$FF,$FE,$1F,$F8,$1F,$7F,$BF,$31,$83,$38,$00,$00,$08,$00
 .db $00,$34,$40,$3F,$FF,$FF,$FF,$FC,$C1,$F9,$FF,$E0,$70,$10,$01,$F8
 .db $00,$00,$00,$00,$00,$FF,$FF,$87,$FF,$FF,$13,$FF,$FE,$81,$FF,$80
 .db $07,$FC,$71,$00,$80,$00,$00,$00,$38,$07,$C2,$7F,$FF,$FF,$FF,$0F
 .db $F0,$00,$0F,$FC,$E0,$7F,$98,$00,$34,$00,$00,$00,$00,$3F,$7F,$FF
 .db $FF,$F8,$F8,$FF,$C3,$5F,$81,$FA,$00,$01,$F8,$08,$00,$00,$00,$00
 .db $13,$F0,$3F,$FF,$FF,$DF,$FF,$F8,$02,$0B,$83,$FC,$3F,$C0,$3C,$00
 .db $00,$00,$01,$80,$85,$D7,$FF,$FF,$FF,$C3,$FF,$80,$3A,$BF,$F8,$01
 .db $D3,$B8,$00,$00,$00,$00,$00,$00,$16,$3F,$FF,$FF,$FE,$7F,$F4,$0F
 .db $C0,$F0,$7C,$0F,$DF,$FE,$00,$00,$00,$00,$00,$7F,$87,$FF,$F8,$7F
 .db $FF,$88,$3E,$E0,$07,$FC,$00,$FB,$80,$1E,$00,$03,$C0,$00,$60,$00
 .db $7F,$FB,$FF,$F9,$98,$5F,$07,$0F,$FE,$61,$87,$CE,$3F,$E0,$00,$03
 .db $F0,$00,$7F,$FC,$00,$FF,$FF,$C0,$7F,$EC,$0C,$FF,$C0,$8F,$F8,$00
 .db $8F,$80,$FF,$60,$00,$FF,$F0,$5E,$FC,$00,$FF,$FE,$1E,$3D,$C1,$37
 .db $8F,$FC,$78,$00,$1C,$81,$C1,$F8,$70,$C3,$C7,$FF,$FC,$00,$EC,$8F
 .db $FF,$FC,$07,$F3,$C3,$3F,$D8,$01,$C0,$87,$9F,$F8,$83,$FF,$80,$0F
 .db $FC,$78,$F8,$00,$7F,$F9,$F1,$FF,$00,$1F,$F8,$00,$18,$00,$0F,$FE
 .db $33,$FF,$88,$19,$FE,$03,$E0,$00,$07,$CF,$1F,$FE,$60,$07,$EF,$00
 .db $FC,$00,$01,$C4,$7F,$F8,$03,$FF,$80,$1F,$FC,$00,$01,$E0,$1F,$FF
 .db $F0,$7F,$92,$01,$F1,$E0,$02,$00,$7F,$F7,$FF,$FF,$E0,$07,$FF,$00
 .db $0C,$00,$18,$FF,$FF,$9E,$7C,$02,$0F,$80,$18,$00,$07,$3D,$F1,$FF
 .db $F9,$FF,$FC,$03,$40,$00,$30,$04,$FF,$FF,$81,$FF,$E0,$07,$44,$00
 .db $00,$03,$FF,$F9,$FF,$FF,$38,$F1,$82,$0C,$30,$01,$1F,$F8,$FF,$F3
 .db $7F,$C0,$03,$C0,$00,$27,$00,$7F,$FF,$E7,$DF,$F8,$10,$F8,$0C,$00
 .db $01,$DF,$FC,$3F,$F3,$D8,$08,$61,$83,$00,$20,$0E,$FF,$FF,$DF,$7F
 .db $FC,$01,$90,$00,$00,$03,$FE,$7F,$FF,$C0,$FF,$00,$18,$80,$01,$F8
 .db $07,$FF,$FF,$BF,$9F,$F8,$40,$00,$E0,$00,$3E,$0F,$9F,$F3,$EF,$F8
 .db $E1,$8C,$30,$00,$0E,$3D,$C7,$FF,$E7,$E7,$38,$20,$00,$60,$00,$3F
 .db $F6,$1F,$FC,$7F,$E6,$30,$E0,$86,$08,$01,$FF,$F8,$FF,$CF,$33,$E4
 .db $00,$10,$01,$3C,$01,$DF,$BE,$7F,$EF,$7C,$E3,$80,$38,$00,$85,$FC
 .db $C7,$9F,$F9,$C7,$C8,$20,$80,$0C,$70,$07,$3F,$E1,$BF,$FD,$E2,$18
 .db $1D,$E0,$06,$3D,$CF,$1E,$3F,$C7,$8C,$7B,$C0,$38,$00,$00,$40,$7F
 .db $84,$7F,$FC,$80,$1C,$38,$00,$00,$3F,$83,$89,$FF,$EF,$FC,$F9,$C0
 .db $00,$00,$01,$07,$F8,$1F,$23,$FE,$11,$CF,$80,$22,$20,$0C,$76,$0F
 .db $FF,$1F,$FF,$80,$19,$E0,$00,$40,$CF,$BC,$03,$FF,$98,$F3,$E4,$71
 .db $C0,$08,$13,$66,$4C,$FF,$FE,$70,$4C,$49,$90,$0E,$01,$C6,$18,$F7
 .db $FC,$9C,$FF,$D8,$30,$00,$00,$3F,$E7,$1D,$F9,$FF,$08,$61,$FE,$00
 .db $F3,$06,$04,$23,$FF,$7C,$E7,$FC,$08,$41,$0C,$03,$87,$CE,$30,$FF
 .db $F8,$91,$FF,$80,$01,$83,$C6,$40,$67,$FD,$F1,$FE,$02,$33,$81,$9F
 .db $E0,$07,$78,$81,$FF,$39,$EF,$8F,$00,$00,$0F,$70,$00,$FC,$3A,$67
 .db $9C,$0F,$80,$0C,$F1,$80,$30,$9F,$FF,$FB,$7F,$B0,$03,$C0,$00,$F3
 .db $C0,$F4,$E0,$1E,$F9,$FF,$CC,$C0,$C1,$02,$F8,$C0,$3F,$FD,$FB,$9E
 .db $01,$E6,$1E,$31,$81,$1C,$61,$FF,$79,$E3,$FE,$BD,$C2,$00,$7D,$E1
 .db $0C,$F3,$8F,$34,$FF,$CC,$00,$E7,$00,$01,$80,$1C,$FB,$FF,$39,$E7
 .db $9C,$01,$E3,$00,$73,$C1,$FF,$B0,$3F,$FE,$03,$8C,$10,$80,$00,$F0
 .db $00,$3F,$F0,$1E,$18,$33,$66,$09,$C1,$00,$3F,$F1,$FE,$3B,$FF,$DC
 .db $03,$80,$08,$71,$80,$3E,$E7,$9F,$38,$FF,$8C,$30,$E7,$0C,$70,$07
 .db $3E,$F9,$8F,$9C,$E1,$86,$18,$61,$8C,$38,$E1,$DE,$3C,$F7,$EE,$30
 .db $71,$80,$0C,$61,$C7,$3F,$F3,$E7,$FE,$71,$82,$3E,$00,$00,$1E,$31
 .db $E3,$FF,$FF,$F3,$FE,$01,$80,$08,$61,$82,$FF,$F3,$CF,$78,$77,$8C
 .db $18,$63,$04,$38,$83,$BF,$78,$F7,$FE,$0C,$F6,$04,$78,$C3,$9B,$E1
 .db $CF,$D8,$7F,$FE,$00,$CF,$00,$60,$00,$0F,$F9,$C7,$FF,$71,$CE,$1E
 .db $61,$80,$1E,$43,$C7,$FC,$C7,$FC,$38,$C3,$80,$01,$C0,$07,$39,$FF
 .db $F3,$3E,$1F,$1C,$03,$CC,$30,$D0,$23,$C4,$FE,$3E,$3E,$F3,$80,$30
 .db $60,$5F,$08,$3F,$DF,$E0,$F7,$CF,$1C,$61,$0E,$18,$01,$F0,$70,$FC
 .db $9E,$FE,$60,$0C,$10,$03,$8C,$10,$FF,$B9,$FB,$FF,$1F,$F8,$00,$7C
 .db $00,$82,$38,$7F,$C6,$1F,$FF,$04,$78,$00,$04,$80,$E1,$00,$3F,$FF
 .db $07,$FE,$00,$0F,$70,$3F,$81,$03,$F3,$C4,$7C,$FE,$06,$18,$C1,$80
 .db $23,$C3,$00,$FB,$F8,$3F,$FF,$FE,$00,$07,$CE,$01,$E3,$F8,$78,$8F
 .db $DE,$70,$63,$FC,$00,$87,$80,$01,$FF,$FC,$0D,$FF,$E2,$00,$F8,$07
 .db $80,$71,$C6,$1E,$3F,$CF,$F0,$60,$0E,$00,$07,$78,$00,$FF,$F1,$0F
 .db $FC,$39,$80,$78,$70,$0F,$FE,$7F,$9F,$01,$FF,$90,$02,$00,$0C,$31
 .db $80,$07,$FD,$E3,$BF,$FF,$01,$FC,$61,$C0,$30,$07,$DB,$87,$E1,$C7
 .db $F8,$00,$00,$00,$0F,$FF,$10,$F3,$FF,$F3,$F7,$84,$08,$FF,$1C,$60
 .db $81,$3F,$E1,$FF,$38,$20,$83,$9C,$20,$00,$3E,$78,$0F,$FE,$61,$FF
 .db $DC,$03,$1F,$1C,$40,$1F,$F0,$01,$FF,$B8,$03,$30,$00,$F0,$40,$30
 .db $07,$FC,$FF,$FF,$82,$F9,$C0,$3E,$C0,$01,$FF,$F8,$0E,$FD,$E0,$F0
 .db $30,$00,$87,$09,$83,$FB,$A6,$7F,$FF,$B8,$04,$7C,$C1,$7E,$20,$2C
 .db $EF,$01,$FF,$C0,$13,$B8,$02,$00,$03,$CE,$C6,$FF,$09,$FF,$F8,$0F
 .db $E3,$00,$7F,$C0,$0E,$11,$CF,$FF,$BF,$C0,$03,$80,$00,$70,$00,$7F
 .db $FE,$1F,$C3,$FF,$FE,$06,$FF,$00,$0F,$F8,$3F,$60,$0F,$FE,$C0,$00
 .db $00,$70,$08,$33,$05,$FF,$79,$7F,$F8,$23,$FF,$C0,$80,$33,$FC,$E2
 .db $3D,$FE,$01,$8F,$F0,$00,$1F,$F0,$00,$78,$21,$FF,$FF,$FF,$80,$07
 .db $E2,$22,$E0,$40,$ED,$FF,$80,$03,$FF,$00,$00,$FD,$80,$02,$FD,$E6
 .db $1F,$FF,$FF,$A0,$01,$FF,$00,$61,$30,$84,$7F,$FF,$E0,$1C,$60,$00
 .db $40,$00,$3F,$9F,$23,$FF,$FF,$CC,$8F,$F0,$02,$EF,$80,$42,$00,$1F
 .db $FF,$F8,$40,$18,$78,$01,$18,$C0,$3F,$FF,$F7,$F8,$1F,$7C,$E6,$00
 .db $0F,$9F,$01,$E1,$CF,$7F,$F0,$00,$60,$00,$7C,$8C,$00,$FD,$FF,$81
 .db $FF,$F8,$07,$FD,$C0,$00,$7F,$FC,$03,$E3,$FF,$BE,$00,$01,$01,$33
 .db $F0,$01,$FF,$FF,$FF,$FF,$00,$0F,$FF,$80,$01,$F2,$3F,$FF,$00,$1B
 .db $FC,$26,$08,$C0,$01,$1F,$60,$63,$F7,$FF,$FE,$00,$0F,$FE,$E0,$01
 .db $00,$33,$EF,$C4,$1C,$F0,$0E,$79,$00,$00,$1F,$FF,$91,$FF,$FF,$FF
 .db $E0,$03,$39,$04,$9C,$00,$0B,$1F,$FF,$B0,$00,$00,$1C,$C0,$00,$1F
 .db $7F,$FF,$9F,$F3,$BE,$7F,$E0,$00,$38,$0B,$CE,$00,$7F,$FF,$7C,$60
 .db $40,$00,$27,$F8,$00,$79,$FF,$FF,$C0,$39,$FF,$EC,$00,$20,$80,$07
 .db $FF,$A3,$39,$FF,$FF,$80,$00,$1F,$E0,$00,$FF,$FE,$F7,$FF,$B0,$42
 .db $0E,$0F,$80,$00,$67,$FE,$F0,$99,$1E,$10,$00,$00,$03,$8E,$7F,$F3
 .db $0C,$FF,$F8,$8C,$63,$3E,$3D,$EF,$80,$00,$F7,$FF,$E0,$00,$7B,$FC
 .db $00,$01,$C6,$3E,$CF,$F9,$FB,$E7,$9F,$F0,$00,$11,$FF,$00,$00,$C7
 .db $9F,$FF,$80,$00,$71,$C0,$18,$88,$1F,$FF,$FF,$FE,$E0,$0F,$FF,$B0
 .db $00,$39,$E7,$98,$80,$0F,$FF,$20,$00,$20,$03,$CF,$FF,$9F,$1C,$FF
 .db $FF,$80,$01,$FF,$B0,$7E,$00,$00,$7F,$CF,$81,$83,$3F,$E2,$00,$00
 .db $67,$F4,$1F,$CF,$E7,$FF,$FB,$FC,$80,$00,$7F,$80,$00,$1F,$FF,$4F
 .db $E3,$00,$16,$00,$00,$30,$23,$FF,$FF,$F0,$7F,$FF,$99,$EE,$40,$03
 .db $FF,$84,$00,$00,$0F,$F8,$00,$0E,$78,$C0,$FD,$F0,$06,$0F,$EF,$FF
 .db $D8,$13,$FF,$F0,$02,$0C,$04,$0C,$F0,$07,$F0,$61,$FE,$18,$01,$FB
 .db $30,$07,$CF,$FF,$FF,$F8,$61,$E0,$30,$4A,$08,$1F,$80,$7F,$E7,$80
 .db $1F,$80,$3C,$60,$C0,$FF,$FD,$3E,$2F,$FF,$FF,$03,$9F,$00,$0C,$F8
 .db $00,$00,$3F,$FE,$08,$01,$E7,$9C,$03,$A0,$37,$F8,$3F,$BF,$FE,$1F
 .db $FF,$FE,$00,$20,$06,$30,$00,$2F,$FC,$1F,$00,$03,$00,$04,$2F,$C6
 .db $70,$FF,$FF,$F1,$02,$3E,$5F,$00,$73,$E0,$00,$6F,$E0,$10,$7F,$38
 .db $01,$F0,$07,$CF,$EF,$BC,$38,$FF,$F3,$3E,$46,$1C,$81,$80,$78,$00
 .db $40,$7A,$70,$1C,$1F,$E1,$86,$03,$0F,$9C,$FC,$3F,$FF,$FF,$A7,$79
 .db $0F,$00,$18,$00,$78,$41,$E0,$FF,$C4,$00,$03,$C0,$18,$01,$F7,$F9
 .db $8F,$FF,$71,$C3,$9F,$8C,$00,$3F,$F0,$18,$00,$F0,$7C,$18,$3F,$80
 .db $E0,$07,$C7,$CE,$06,$FF,$FF,$F0,$7F,$BF,$9E,$0E,$40,$60,$01,$83
 .db $30,$F0,$E0,$0D,$F9,$80,$1F,$33,$BF,$6D,$DF,$BF,$F3,$F0,$3C,$F8
 .db $0C,$19,$38,$0C,$04,$FF,$80,$00,$F7,$20,$60,$00,$FF,$8F,$1F,$FE
 .db $5F,$F9,$F3,$FD,$E0,$32,$C4,$C0,$00,$01,$67,$03,$C0,$C0,$C3,$F3
 .db $83,$81,$FF,$9F,$E3,$FF,$E3,$CF,$1F,$00,$00,$21,$C0,$83,$E0,$FE
 .db $3E,$00,$3E,$00,$1C,$1F,$F0,$FF,$E3,$FF,$FF,$F0,$7E,$0C,$60,$D0
 .db $E0,$07,$87,$F0,$3C,$30,$03,$C1,$80,$07,$37,$F8,$F8,$3F,$C7,$FE
 .db $7E,$70,$61,$E0,$FE,$00,$04,$01,$E0,$9E,$40,$E1,$03,$E4,$07,$8F
 .db $F7,$E3,$F0,$FF,$FE,$7F,$8F,$00,$0F,$80,$F9,$80,$F8,$3F,$C0,$1E
 .db $00,$38,$01,$E0,$FB,$87,$FF,$3F,$F3,$E6,$CF,$E0,$03,$F0,$18,$3C
 .db $1C,$1D,$81,$87,$C0,$00,$F8,$03,$F8,$1F,$FF,$A7,$1F,$FC,$5F,$E0
 .db $6E,$1C,$00,$78,$01,$FF,$03,$FF,$F0,$00,$FC,$10,$00,$C0,$FF,$E0
 .db $7F,$BF,$FE,$3F,$C0,$C3,$80,$DB,$F8,$18,$70,$03,$FF,$80,$02,$60
 .db $03,$80,$07,$FE,$07,$FF,$FC,$7F,$00,$7F,$C0,$00,$3F,$00,$FC,$01
 .db $F4,$2F,$C0,$B1,$03,$80,$01,$FF,$F4,$5F,$FF,$FF,$EF,$C0,$0F,$C0
 .db $00,$0F,$80,$1B,$E0,$F8,$99,$10,$00,$04,$08,$00,$FF,$E1,$FF,$FE
 .db $DF,$FF,$03,$BB,$80,$20,$0C,$9B,$11,$83,$27,$81,$F8,$00,$18,$18
 .db $00,$1F,$EF,$E3,$FF,$FA,$F8,$F0,$17,$FC,$02,$01,$F0,$7F,$00,$1F
 .db $7E,$08,$10,$00,$E0,$00,$3F,$F8,$3F,$FF,$C7,$FC,$40,$FF,$E0,$07
 .db $07,$83,$E0,$70,$FC,$18,$1C,$01,$00,$00,$01,$FF,$BF,$FF,$FF,$EF
 .db $FF,$F0,$01,$80,$00,$78,$60,$EF,$D8,$1F,$17,$00,$00,$0C,$00,$00
 .db $FF,$07,$FF,$FF,$67,$FD,$03,$7C,$00,$00,$1F,$FC,$78,$17,$E0,$3F
 .db $E4,$00,$1C,$00,$03,$C1,$7F,$F9,$FF,$EF,$F1,$FE,$03,$FF,$80,$1E
 .db $0F,$83,$F8,$09,$FB,$06,$00,$0C,$00,$00,$7F,$FC,$1F,$FF,$FC,$3F
 .db $C0,$F0,$FC,$00,$09,$07,$FC,$07,$E7,$E0,$60,$10,$03,$80

.end
