; READKEY      - by Jimmy Mardell <mja@algonet.se>

; Works almost exactly like call GET_KEY, but since
; GET_KEY can't be used inside interrupt handlers, this
; routine may be handy.

; Multiple keys will return a=0.

; Length of routine: 62 byte

ReadKey:
 push bc
 push de
 push hl
 ld a,%11111110
 ld hl,0
RepMask:
 push af
 out (1),a
 in a,(1)
 ld e,0
 ld b,8
RepBitTest:
 inc e
 bit 0,a
 jr nz,NoBit
 push af
 bit 7,h
 jr nz,TwoKeys
 ld a,l
 add a,e
 ld h,a
 set 7,h
 pop af
NoBit:
 srl a
 djnz RepBitTest
 ld a,l
 add a,8
 ld l,a
 pop af
 rlca
 bit 7,a
 jr nz,RepMask
 ld a,h
 and %01111111
KeyDone:
 pop hl
 pop de
 pop bc
 ret
TwoKeys:
 pop af
 pop af
 xor a
 jr KeyDone
